/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.EnumProperties;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum SqlSecurity implements EnumProperties
{
    Invoker("SECURITY INVOKER", ".*(Invoker|Caller)\\s*"),
    Definer("SECURITY DEFINER", ".*(Definer|Owner)\\s*");

    private final Pattern pattern;
    private final String text;

    private SqlSecurity(String text, String patternText) {
        this.text = text;
        this.pattern = Pattern.compile(patternText, 2);
    }

    public static SqlSecurity parse(String text) {
        if (text == null) {
            return null;
        }
        for (SqlSecurity rule : SqlSecurity.values()) {
            Matcher matcher = rule.pattern.matcher(text);
            if (!matcher.matches()) continue;
            return rule;
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        return this.text;
    }

    @Override
    public String getDisplayName(Locale locale) {
        return this.getDisplayName();
    }

    @Override
    public String getSqlValue() {
        return this.getDisplayName();
    }
}

