/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.Body;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.TypeBody;
import com.sqlapp.data.schemas.TypeCollection;
import com.sqlapp.data.schemas.TypeColumnCollection;
import com.sqlapp.data.schemas.properties.CollationProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.MetaTypeProperty;
import com.sqlapp.data.schemas.properties.object.TypeColumnsProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;

public final class Type
extends AbstractSchemaObject<Type>
implements HasParent<TypeCollection>,
CollationProperty<Type>,
MetaTypeProperty<Type>,
TypeColumnsProperty<Type>,
Body<TypeBody> {
    private static final long serialVersionUID = -6503734410877376997L;
    private MetaType metaType = MetaType.Default;
    private TypeColumnCollection columns = new TypeColumnCollection(this);
    private String collation = null;

    protected Type() {
    }

    public Type(String name) {
        super(name);
    }

    @Override
    protected Supplier<Type> newInstance() {
        return () -> new Type();
    }

    @Override
    protected void toString(ToStringBuilder builder) {
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof Type)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        Type val = (Type)obj;
        if (!this.equals(SchemaProperties.META_TYPE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.COLLATION, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaObjectProperties.TYPE_COLUMNS, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        builder.add(SchemaProperties.META_TYPE.getLabel(), (Object)this.getMetaType());
        builder.add(SchemaProperties.COLLATION.getLabel(), this.getCollation());
        builder.add((ISchemaProperty)SchemaObjectProperties.TYPE_COLUMNS, (Object)this.getColumns());
    }

    @Override
    public TypeColumnCollection getColumns() {
        return this.columns;
    }

    protected Type setColumns(TypeColumnCollection columns) {
        if (this.columns != null) {
            this.columns.setParent(null);
        }
        this.columns = columns;
        if (this.columns != null) {
            this.columns.setParent(this);
        }
        return this;
    }

    @Override
    public MetaType getMetaType() {
        return this.metaType;
    }

    @Override
    public Type setMetaType(MetaType metaType) {
        this.metaType = metaType;
        return this;
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        if (!CommonUtils.eqIgnoreCase(this.getParentCollationName(), this.getCollation())) {
            stax.writeAttribute(SchemaProperties.COLLATION.getLabel(), this.getCollation());
        }
        if (this.metaType != MetaType.Default) {
            stax.writeAttribute(SchemaProperties.META_TYPE.getLabel(), (Object)this.getMetaType());
        }
        super.writeXmlOptionalAttributes(stax);
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        if (!CommonUtils.isEmpty(this.columns)) {
            this.columns.writeXml(stax);
        }
        super.writeXmlOptionalValues(stax);
    }

    @Override
    public Type setCaseSensitive(boolean caseSensitive) {
        this.columns.setCaseSensitive(caseSensitive);
        return (Type)super.setCaseSensitive(caseSensitive);
    }

    @Override
    public TypeCollection getParent() {
        return (TypeCollection)super.getParent();
    }

    @Override
    public String getCollation() {
        if (this.collation == null) {
            return this.getParentCollationName();
        }
        return this.collation;
    }

    private String getParentCollationName() {
        Schema schema = this.getAncestor(Schema.class);
        if (schema != null) {
            return schema.getCollation();
        }
        return null;
    }

    @Override
    public Type setCollation(String collationName) {
        this.collation = collationName;
        return this;
    }

    @Override
    public TypeBody getBody() {
        if (this.getParent() != null && this.getParent().getParent() != null) {
            return (TypeBody)this.getParent().getParent().getTypeBodies().get(this.getName());
        }
        return null;
    }

    public static enum MetaType {
        Row("r.*"),
        Cursor("c.*"),
        Default("[^rc].*");

        final Pattern pattern;

        private MetaType(String patternText) {
            this.pattern = Pattern.compile(patternText, 2);
        }

        public static MetaType parse(String text) {
            if (text == null) {
                return null;
            }
            for (MetaType metaType : MetaType.values()) {
                Matcher matcher = metaType.pattern.matcher(text);
                if (!matcher.matches()) continue;
                return metaType;
            }
            return null;
        }
    }
}

