/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas.properties.complex;

import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.Type;
import com.sqlapp.data.schemas.properties.ImplementationTypeNameProperty;
import com.sqlapp.data.schemas.properties.ImplementationTypeSchemaNameProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SimpleBeanUtils;

public interface ImplementationTypeProperty<T extends DbCommonObject<?>>
extends ImplementationTypeNameProperty<T>,
ImplementationTypeSchemaNameProperty<T> {
    default public Type getImplementationType() {
        Type obj = (Type)SimpleBeanUtils.getField(this, SchemaProperties.IMPLEMENTATION_TYPE_NAME.getLabel().replaceAll("Name", ""));
        if (obj != null && obj.getParent() == null) {
            this.setImplementationType(obj);
        }
        return obj;
    }

    default public T setImplementationType(Type value) {
        if (this instanceof DbCommonObject) {
            value = SchemaUtils.getTypeFromParent(value, (DbCommonObject)((Object)this));
        }
        SimpleBeanUtils.setField(this, SchemaProperties.IMPLEMENTATION_TYPE_NAME.getLabel().replaceAll("Name", ""), value);
        return (T)((DbCommonObject)((Object)this));
    }

    @Override
    default public String getImplementationTypeSchemaName() {
        return this.getImplementationType() == null ? null : this.getImplementationType().getSchemaName();
    }

    @Override
    default public String getImplementationTypeName() {
        return this.getImplementationType() == null ? null : this.getImplementationType().getName();
    }

    @Override
    default public T setImplementationTypeName(String name) {
        if (CommonUtils.isEmpty(name)) {
            this.setImplementationType(null);
        } else if (this.getImplementationType() == null || !CommonUtils.eq(this.getImplementationTypeName(), name)) {
            Type obj = new Type(name);
            this.setImplementationType(obj);
        }
        return (T)((DbCommonObject)((Object)this));
    }

    @Override
    default public T setImplementationTypeSchemaName(String name) {
        if (this.getImplementationType() == null || !CommonUtils.eq(this.getImplementationTypeSchemaName(), name)) {
            Type obj = new Type(name);
            obj.setSchemaName(name);
            this.setImplementationType(obj);
        }
        return (T)((DbCommonObject)((Object)this));
    }
}

