/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas.properties.complex;

import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.Function;
import com.sqlapp.data.schemas.OperatorArgument;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.properties.JoinFunctionNameProperty;
import com.sqlapp.data.schemas.properties.JoinFunctionSchemaNameProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SimpleBeanUtils;

public interface JoinFunctionProperty<T extends DbCommonObject<?>>
extends JoinFunctionNameProperty<T>,
JoinFunctionSchemaNameProperty<T> {
    default public Function getJoinFunction() {
        Function obj = (Function)SimpleBeanUtils.getField(this, SchemaProperties.RESTRICT_FUNCTION_NAME.getLabel().replaceAll("Name", ""));
        if (obj != null && obj.getParent() == null) {
            this.setJoinFunction(obj);
        }
        return obj;
    }

    default public T setJoinFunction(Function value) {
        if (this instanceof DbCommonObject) {
            OperatorArgument leftArgument = (OperatorArgument)SimpleBeanUtils.getField(this, "leftArgument");
            OperatorArgument rightArgument = (OperatorArgument)SimpleBeanUtils.getField(this, "rightArgument");
            value = SchemaUtils.getFunctionFromParent(value, leftArgument, rightArgument, (DbCommonObject)((Object)this));
        }
        SimpleBeanUtils.setField(this, SchemaProperties.RESTRICT_FUNCTION_NAME.getLabel().replaceAll("Name", ""), value);
        return (T)((DbCommonObject)((Object)this));
    }

    @Override
    default public String getJoinFunctionSchemaName() {
        return this.getJoinFunction() == null ? null : this.getJoinFunction().getSchemaName();
    }

    @Override
    default public String getJoinFunctionName() {
        return this.getJoinFunction() == null ? null : this.getJoinFunction().getName();
    }

    @Override
    default public T setJoinFunctionName(String name) {
        if (CommonUtils.isEmpty(name)) {
            this.setJoinFunction(null);
        } else if (this.getJoinFunction() == null || !CommonUtils.eq(this.getJoinFunctionName(), name)) {
            String[] args = name.split("\\.");
            Function obj = new Function(CommonUtils.last(args));
            if (args.length > 1) {
                obj.setSchemaName(args[args.length - 2]);
            }
            this.setJoinFunction(obj);
        }
        return (T)((DbCommonObject)((Object)this));
    }

    @Override
    default public T setJoinFunctionSchemaName(String schemaName) {
        if (this.getJoinFunction() == null || !CommonUtils.eq(this.getJoinFunctionSchemaName(), schemaName)) {
            Function obj = new Function();
            obj.setSchemaName(schemaName);
            this.setJoinFunction(obj);
        }
        return (T)((DbCommonObject)((Object)this));
    }
}

