/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas.rowiterator;

import com.sqlapp.data.db.dialect.DialectUtils;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.RowCollection;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.function.RowValueConverter;
import com.sqlapp.data.schemas.rowiterator.AbstractListIterator;

public abstract class AbstractRowListIterator<T>
extends AbstractListIterator {
    protected final Table table;
    protected long index = 0L;
    protected long count = 0L;
    private long limit = Long.MAX_VALUE;
    private boolean init = false;
    private boolean hasNext = false;
    private boolean dispose = false;

    protected AbstractRowListIterator(RowCollection c, long index, RowValueConverter rowValueConverter) {
        super(rowValueConverter);
        this.table = c.getParent();
        this.index = index;
    }

    private void initialize() throws Exception {
        if (this.init) {
            return;
        }
        this.preInitialize();
        this.initializeColumn();
        for (long i = 0L; i < this.index && this.hasNextInternal(); ++i) {
            this.read();
        }
        this.init = true;
    }

    protected abstract void preInitialize() throws Exception;

    protected abstract void initializeColumn() throws Exception;

    protected abstract T read() throws Exception;

    @Override
    public boolean hasNext() {
        try {
            this.initialize();
            if (this.count >= this.limit) {
                this.hasNext = false;
                return this.hasNext;
            }
            this.hasNext = this.hasNextInternal();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!this.hasNext) {
            this.closeSilent();
        } else {
            ++this.count;
        }
        return this.hasNext;
    }

    protected abstract boolean hasNextInternal() throws Exception;

    protected abstract void set(T var1, Row var2) throws Exception;

    @Override
    public Row next() {
        Row row = this.table.newRow();
        try {
            T t = this.read();
            this.set(t, row);
            Row row2 = row;
            return row2;
        }
        catch (RuntimeException e) {
            this.closeSilent();
            throw e;
        }
        catch (Exception e) {
            this.closeSilent();
            throw new RuntimeException(e);
        }
        finally {
            if (!this.hasNext) {
                this.closeSilent();
            }
        }
    }

    protected abstract void doClose();

    protected void put(Row row, Column column, Object value) {
        if (column.getDataType() != null && column.getDataType().isBinary() && value instanceof String) {
            SchemaUtils.putDialect(row, column, this.getRowValueConverter().apply(row, column, value));
        } else {
            row.put(column, this.getRowValueConverter().apply(row, column, value));
        }
    }

    protected void closeSilent() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void close() throws Exception {
        if (!this.dispose) {
            this.doClose();
            this.dispose = true;
        }
    }

    protected long getTypeLength(String value) {
        return DialectUtils.getDefaultTypeLength(value);
    }
}

