/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas.rowiterator;

import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.RowCollection;
import com.sqlapp.data.schemas.function.RowValueConverter;
import com.sqlapp.data.schemas.rowiterator.AbstractRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.AbstractTextRowListIterator;
import com.sqlapp.data.schemas.rowiterator.WorkbookFileType;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FileUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.supercsv.io.ICsvListReader;

public class CsvRowIteratorHandler
extends AbstractRowIteratorHandler {
    private final File file;
    private final Path path;
    private final WorkbookFileType workbookFileType;
    private final String charset;
    private final Reader reader;
    private final int skipHeaderRowsSize;

    public CsvRowIteratorHandler(File file, String charset) {
        this(file, charset, 1);
    }

    public CsvRowIteratorHandler(File file, String charset, int skipHeaderRowsSize) {
        super((r, c, v) -> v);
        this.workbookFileType = WorkbookFileType.parse(file);
        this.file = file;
        this.path = null;
        this.charset = charset;
        this.reader = null;
        this.skipHeaderRowsSize = skipHeaderRowsSize;
    }

    public CsvRowIteratorHandler(Path path, String charset) {
        this(path, charset, 1);
    }

    public CsvRowIteratorHandler(Path path, String charset, int skipHeaderRowsSize) {
        super((r, c, v) -> v);
        this.workbookFileType = WorkbookFileType.parse(path);
        this.file = null;
        this.path = path;
        this.charset = charset;
        this.reader = null;
        this.skipHeaderRowsSize = skipHeaderRowsSize;
    }

    public CsvRowIteratorHandler(File file, String charset, RowValueConverter valueConverter) {
        this(file, charset, 1, valueConverter);
    }

    public CsvRowIteratorHandler(File file, String charset, int skipHeaderRowsSize, RowValueConverter valueConverter) {
        super(valueConverter);
        this.workbookFileType = WorkbookFileType.parse(file);
        this.file = file;
        this.path = null;
        this.charset = charset;
        this.reader = null;
        this.skipHeaderRowsSize = skipHeaderRowsSize;
    }

    public CsvRowIteratorHandler(Reader reader, WorkbookFileType workbookFileType) {
        this(reader, 1, workbookFileType);
    }

    public CsvRowIteratorHandler(Reader reader, int skipHeaderRowsSize, WorkbookFileType workbookFileType) {
        super((r, c, v) -> v);
        this.workbookFileType = workbookFileType;
        this.file = null;
        this.path = null;
        this.charset = null;
        this.reader = reader;
        this.skipHeaderRowsSize = skipHeaderRowsSize;
    }

    @Override
    public Iterator<Row> iterator(RowCollection c) {
        if (this.file != null) {
            return new CsvRowIterator(c, this.file, this.skipHeaderRowsSize, this.workbookFileType, this.charset, 0L, this.getRowValueConverter());
        }
        if (this.path != null) {
            return new CsvRowIterator(c, this.path, this.skipHeaderRowsSize, this.workbookFileType, this.charset, 0L, this.getRowValueConverter());
        }
        return new CsvRowIterator(c, this.reader, this.skipHeaderRowsSize, this.workbookFileType, 0L, this.getRowValueConverter());
    }

    @Override
    public ListIterator<Row> listIterator(RowCollection c, int index) {
        if (this.file != null) {
            return new CsvRowIterator(c, this.file, this.skipHeaderRowsSize, this.workbookFileType, this.charset, (long)index, this.getRowValueConverter());
        }
        if (this.path != null) {
            return new CsvRowIterator(c, this.path, this.skipHeaderRowsSize, this.workbookFileType, this.charset, (long)index, this.getRowValueConverter());
        }
        return new CsvRowIterator(c, this.reader, this.skipHeaderRowsSize, this.workbookFileType, index, this.getRowValueConverter());
    }

    @Override
    public ListIterator<Row> listIterator(RowCollection c) {
        return (ListIterator)this.iterator(c);
    }

    static class ColumnPosition {
        public final int index;
        public final Column column;

        ColumnPosition(int index, Column column) {
            this.index = index;
            this.column = column;
        }
    }

    public static class CsvRowIterator
    extends AbstractTextRowListIterator<List<String>> {
        private final File file;
        private final Path path;
        private final WorkbookFileType workbookFileType;
        private final String charset;
        private Reader reader;
        private ICsvListReader csvReader;
        private String filename;
        private List<ColumnPosition> columns;
        private List<String> current = null;
        private final int skipHeaderRowsSize;
        private boolean readed = false;

        CsvRowIterator(RowCollection c, Path path, int skipHeaderRowsSize, WorkbookFileType workbookFileType, String charset, long index, RowValueConverter valueConverter) {
            super(c, index, valueConverter);
            this.workbookFileType = workbookFileType;
            this.file = null;
            this.path = path;
            this.charset = charset;
            this.filename = path.toFile().getName();
            this.skipHeaderRowsSize = skipHeaderRowsSize;
        }

        CsvRowIterator(RowCollection c, File file, int skipHeaderRowsSize, WorkbookFileType workbookFileType, String charset, long index, RowValueConverter valueConverter) {
            super(c, index, valueConverter);
            this.workbookFileType = workbookFileType;
            this.file = file;
            this.path = null;
            this.charset = charset;
            this.filename = file.getAbsolutePath();
            this.skipHeaderRowsSize = skipHeaderRowsSize;
        }

        CsvRowIterator(RowCollection c, Reader reader, int skipHeaderRowsSize, WorkbookFileType workbookFileType, long index, RowValueConverter valueConverter) {
            super(c, index, valueConverter);
            this.workbookFileType = workbookFileType;
            this.file = null;
            this.path = null;
            this.reader = reader;
            this.charset = null;
            this.filename = null;
            this.skipHeaderRowsSize = skipHeaderRowsSize;
        }

        @Override
        protected void preInitialize() throws Exception {
            if (this.file != null) {
                this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), this.charset));
                this.csvReader = this.workbookFileType.createCsvListReader(this.reader);
                this.filename = this.file.getAbsolutePath();
            } else if (this.path != null) {
                this.reader = Files.newBufferedReader(this.path, Charset.forName(this.charset));
                this.csvReader = this.workbookFileType.createCsvListReader(this.reader);
                this.filename = this.path.toFile().getAbsolutePath();
            } else {
                if (this.reader instanceof BufferedReader) {
                    this.csvReader = this.workbookFileType.createCsvListReader(this.reader);
                } else {
                    BufferedReader br = new BufferedReader(this.reader);
                    this.csvReader = this.workbookFileType.createCsvListReader(br);
                }
                this.filename = null;
            }
        }

        @Override
        protected void initializeColumn() throws Exception {
            block9: {
                int i;
                block7: {
                    List list;
                    block8: {
                        if (this.skipHeaderRowsSize != 1) break block7;
                        this.columns = CommonUtils.list();
                        list = this.csvReader.read();
                        if (!CommonUtils.isEmpty(this.table.getColumns())) break block8;
                        int i2 = 0;
                        for (String columnName : list) {
                            Column column = new Column(columnName);
                            this.columns.add(new ColumnPosition(i2, column));
                            this.table.getColumns().add(column);
                            ++i2;
                        }
                        break block9;
                    }
                    int i3 = 0;
                    for (String columnName : list) {
                        Column column = this.searchColumn(this.table, columnName);
                        if (column != null) {
                            this.columns.add(new ColumnPosition(i3, column));
                        } else {
                            this.columns.add(new ColumnPosition(i3, null));
                        }
                        ++i3;
                    }
                    if (!this.columns.isEmpty()) break block9;
                    i3 = 0;
                    for (Column column : this.table.getColumns()) {
                        this.columns.add(new ColumnPosition(i3, column));
                        ++i3;
                    }
                    break block9;
                }
                for (i = 0; i < this.skipHeaderRowsSize; ++i) {
                    List list = this.csvReader.read();
                    if (list != null) continue;
                    return;
                }
                this.columns = CommonUtils.list();
                i = 0;
                for (Column column : this.table.getColumns()) {
                    this.columns.add(new ColumnPosition(i, column));
                    ++i;
                }
            }
        }

        @Override
        protected boolean hasNextInternal() throws Exception {
            this.readInternal();
            return this.current != null;
        }

        protected List<String> readInternal() throws Exception {
            if (this.readed) {
                return this.current;
            }
            this.current = this.csvReader.read();
            this.readed = true;
            return this.current;
        }

        @Override
        protected List<String> read() throws Exception {
            this.current = this.readInternal();
            this.readed = false;
            return this.current;
        }

        @Override
        protected void set(List<String> val, Row row) throws Exception {
            row.setDataSourceInfo(this.filename);
            row.setDataSourceRowNumber(this.csvReader.getLineNumber());
            int i = 0;
            if (val == null) {
                return;
            }
            for (String text : val) {
                if (i >= this.columns.size()) continue;
                ColumnPosition columnPosition = this.columns.get(i++);
                Column column = columnPosition.column;
                if (column == null) continue;
                DataType type = this.getDataType(text);
                if (type != null) {
                    if (column.getDataType() == null) {
                        column.setDataType(type);
                    } else if (!column.getDataType().isCharacter() && !type.isBoolean() && column.getDataType() != DataType.DOUBLE) {
                        column.setDataType(type);
                    }
                }
                long len = this.getTypeLength(text);
                if (column.getLength() != null) {
                    column.setLength(Math.max(len, column.getLength()));
                } else {
                    column.setLength(len);
                }
                this.put(row, column, text);
            }
        }

        @Override
        protected void doClose() {
            FileUtils.close((Closeable)this.csvReader);
            FileUtils.close(this.reader);
            this.csvReader = null;
            this.reader = null;
        }
    }
}

