/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas.rowiterator;

import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.RowCollection;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.function.RowValueConverter;
import com.sqlapp.data.schemas.rowiterator.AbstractRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.AbstractRowListIterator;
import com.sqlapp.data.schemas.rowiterator.ExcelUtils;
import com.sqlapp.data.schemas.rowiterator.WorkbookFileType;
import com.sqlapp.util.CommonUtils;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelRowIteratorHandler
extends AbstractRowIteratorHandler {
    private final File file;
    private final int skipHeaderRowsSize;

    public ExcelRowIteratorHandler(File file, int skipHeaderRowsSize, RowValueConverter valueConverter) {
        super(valueConverter);
        this.file = file;
        this.skipHeaderRowsSize = skipHeaderRowsSize;
    }

    public ExcelRowIteratorHandler(File file, RowValueConverter valueConverter) {
        this(file, 1, valueConverter);
    }

    public ExcelRowIteratorHandler(File file, int skipHeaderRowsSize) {
        super((Row r, Column c, Object v) -> v);
        this.file = file;
        this.skipHeaderRowsSize = skipHeaderRowsSize;
    }

    public ExcelRowIteratorHandler(File file) {
        this(file, 1);
    }

    @Override
    public Iterator<Row> iterator(RowCollection c) {
        return new ExcelIterator(c, this.file, 0L, this.getRowValueConverter(), this.skipHeaderRowsSize);
    }

    @Override
    public ListIterator<Row> listIterator(RowCollection c, int index) {
        return new ExcelIterator(c, this.file, index, this.getRowValueConverter(), this.skipHeaderRowsSize);
    }

    @Override
    public ListIterator<Row> listIterator(RowCollection c) {
        return (ListIterator)this.iterator(c);
    }

    public static class ExcelIterator
    extends AbstractRowListIterator<org.apache.poi.ss.usermodel.Row> {
        private final File file;
        private Workbook workbook;
        private final String filename;
        private final int skipHeaderRowsSize;
        private final Map<Number, Column> columnIndexColumnMap = CommonUtils.map();
        private final Map<Number, Boolean> columnIndexFixedTypeMap = CommonUtils.map();
        private Iterator<org.apache.poi.ss.usermodel.Row> rowIterator;

        ExcelIterator(RowCollection c, File file, long index, RowValueConverter valueConverter, int skipHeaderRowsSize) {
            super(c, index, valueConverter);
            this.file = file;
            this.filename = file.getAbsolutePath();
            this.skipHeaderRowsSize = skipHeaderRowsSize;
        }

        @Override
        protected void preInitialize() throws Exception {
            this.workbook = WorkbookFileType.createWorkBook(this.file);
        }

        @Override
        protected org.apache.poi.ss.usermodel.Row read() {
            return this.rowIterator.next();
        }

        @Override
        protected boolean hasNextInternal() {
            return this.rowIterator.hasNext();
        }

        @Override
        protected void initializeColumn() throws IOException {
            Sheet sheet = this.workbook.getSheetAt(0);
            this.rowIterator = sheet.rowIterator();
            if (!this.hasNextInternal()) {
                return;
            }
            org.apache.poi.ss.usermodel.Row headerRow = this.read();
            if (CommonUtils.isEmpty(this.table.getColumns())) {
                headerRow.forEach(cell -> {
                    Object obj = ExcelUtils.getCellValue(cell);
                    if (!(obj instanceof String)) {
                        return;
                    }
                    String columnName = (String)obj;
                    Column column = new Column(columnName);
                    this.columnIndexColumnMap.put(cell.getColumnIndex(), column);
                    this.columnIndexFixedTypeMap.put(cell.getColumnIndex(), false);
                    this.table.getColumns().add(column);
                });
            } else {
                boolean[] hasType = new boolean[]{true};
                headerRow.forEach(cell -> {
                    Object obj = ExcelUtils.getCellValue(cell);
                    if (!(obj instanceof String)) {
                        return;
                    }
                    String columnName = (String)obj;
                    Column column = this.searchColumn(this.table, columnName);
                    this.columnIndexFixedTypeMap.put(cell.getColumnIndex(), false);
                    if (column != null) {
                        if (column.getDataType() != null) {
                            this.columnIndexFixedTypeMap.put(cell.getColumnIndex(), true);
                        }
                        this.columnIndexColumnMap.put(cell.getColumnIndex(), column);
                    }
                });
            }
        }

        protected void initializeColumn2() throws Exception {
            if (this.skipHeaderRowsSize == 1) {
                if (!this.hasNextInternal()) {
                    return;
                }
                org.apache.poi.ss.usermodel.Row headerRow = this.read();
                if (CommonUtils.isEmpty(this.table.getColumns())) {
                    headerRow.forEach(cell -> {
                        Object obj = ExcelUtils.getCellValue(cell);
                        if (!(obj instanceof String)) {
                            return;
                        }
                        String columnName = (String)obj;
                        Column column = new Column(columnName);
                        this.columnIndexColumnMap.put(cell.getColumnIndex(), column);
                        this.columnIndexFixedTypeMap.put(cell.getColumnIndex(), false);
                        this.table.getColumns().add(column);
                    });
                } else {
                    boolean[] hasType = new boolean[]{true};
                    headerRow.forEach(cell -> {
                        Object obj = ExcelUtils.getCellValue(cell);
                        if (!(obj instanceof String)) {
                            return;
                        }
                        String columnName = (String)obj;
                        Column column = this.searchColumn(this.table, columnName);
                        this.columnIndexFixedTypeMap.put(cell.getColumnIndex(), false);
                        if (column != null) {
                            if (column.getDataType() != null) {
                                this.columnIndexFixedTypeMap.put(cell.getColumnIndex(), true);
                            }
                            this.columnIndexColumnMap.put(cell.getColumnIndex(), column);
                        }
                    });
                    if (this.columnIndexColumnMap.isEmpty()) {
                        this.setColumnTypeMap(this.table);
                    }
                }
            } else {
                for (int i = 0; i < this.skipHeaderRowsSize; ++i) {
                    this.read();
                }
                this.setColumnTypeMap(this.table);
            }
        }

        private void setColumnTypeMap(Table table) {
            int i = 0;
            for (Column column : table.getColumns()) {
                if (column.getDataType() != null) {
                    this.columnIndexFixedTypeMap.put(i, true);
                }
                this.columnIndexColumnMap.put(i, column);
                ++i;
            }
        }

        @Override
        protected void set(org.apache.poi.ss.usermodel.Row excelRow, Row row) throws Exception {
            row.setDataSourceInfo(this.filename);
            row.setDataSourceDetailInfo(excelRow.getSheet().getSheetName());
            row.setDataSourceRowNumber(excelRow.getRowNum() + 1);
            excelRow.forEach(cell -> {
                Column column = this.columnIndexColumnMap.get(cell.getColumnIndex());
                if (column == null) {
                    return;
                }
                Boolean fixed = this.columnIndexFixedTypeMap.get(cell.getColumnIndex());
                Object value = ExcelUtils.getCellValue(cell);
                if (value != null) {
                    if (!fixed.booleanValue()) {
                        ExcelUtils.setColumnType(cell, column);
                        if (value instanceof String) {
                            if (column.getLength() != null) {
                                column.setLength(Math.max(this.getTypeLength((String)value), column.getLength()));
                            } else {
                                column.setLength(this.getTypeLength((String)value));
                            }
                        }
                    }
                    this.put(row, column, value);
                }
            });
        }

        @Override
        protected void doClose() {
            try {
                if (this.workbook != null) {
                    this.workbook.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

