/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc.sql;

import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.datatype.DbDataType;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.jdbc.sql.BindParameter;
import com.sqlapp.jdbc.sql.GeneratedKeyHandler;
import com.sqlapp.jdbc.sql.JdbcHandler;
import com.sqlapp.jdbc.sql.ParameterDirection;
import com.sqlapp.jdbc.sql.SqlParameterCollection;
import com.sqlapp.jdbc.sql.node.SqlNode;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.List;

public class CallableJdbcHandler
extends JdbcHandler {
    public CallableJdbcHandler(SqlNode node) {
        super(node, null);
    }

    public CallableJdbcHandler(SqlNode node, GeneratedKeyHandler generatedKeyHandler) {
        super(node, generatedKeyHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(Connection connection, Object context) throws SQLException {
        JdbcHandler.StatementSqlParametersHolder statementSqlParametersHolder = null;
        try {
            statementSqlParametersHolder = this.createStatement(connection, context, null);
            this.handlePreparedStatement(statementSqlParametersHolder.getPreparedStatement());
        }
        catch (Throwable throwable) {
            this.close(statementSqlParametersHolder);
            throw throwable;
        }
        this.close(statementSqlParametersHolder);
    }

    @Override
    protected JdbcHandler.StatementSqlParametersHolder createStatement(Connection connection, Object context, Integer limit) throws SQLException {
        SqlParameterCollection sqlParameters = this.getNode().eval(context);
        CallableStatement statement = this.createStatement(connection, sqlParameters, limit);
        return new JdbcHandler.StatementSqlParametersHolder(statement, sqlParameters);
    }

    @Override
    protected CallableStatement createStatement(Connection connection, SqlParameterCollection sqlParameters, Integer limit) throws SQLException {
        CallableStatement statement = this.getStatement(connection, sqlParameters, limit);
        this.setBind(statement, sqlParameters);
        return statement;
    }

    @Override
    protected CallableStatement getStatement(Connection connection, SqlParameterCollection sqlParameters, Integer limit) throws SQLException {
        CallableStatement statement = connection.prepareCall(sqlParameters.getSql());
        return statement;
    }

    protected void setBind(CallableStatement statement, SqlParameterCollection sqlParameters) throws SQLException {
        List<BindParameter> list = sqlParameters.getBindParameters();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            BindParameter bindParameter = list.get(i);
            if (ParameterDirection.Output.equals((Object)bindParameter.getDirection())) {
                this.registerOutParameter(statement, sqlParameters.getDialect(), bindParameter, i + 1);
                continue;
            }
            this.setParameter(statement, this.getDialect(), bindParameter, i + 1);
        }
    }

    protected void registerOutParameter(CallableStatement statement, Dialect dialect, BindParameter bindParameter, int index) throws SQLException {
        DataType type = bindParameter.getType();
        if (bindParameter.getType() != null) {
            if (dialect != null) {
                DbDataType<?> dbDataType = dialect.getDbDataTypes().getDbType(type);
                statement.registerOutParameter(index, (SQLType)type.getJdbcType(), dbDataType.getTypeName());
            } else {
                statement.registerOutParameter(index, (SQLType)type.getJdbcType());
            }
        } else {
            statement.registerOutParameter(index, (SQLType)type.getJdbcType());
        }
    }
}

