/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc.sql;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.datatype.DbDataType;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.BindParameter;
import com.sqlapp.jdbc.sql.GeneratedKeyHandler;
import com.sqlapp.jdbc.sql.ResultSetConcurrency;
import com.sqlapp.jdbc.sql.ResultSetHoldability;
import com.sqlapp.jdbc.sql.ResultSetType;
import com.sqlapp.jdbc.sql.SqlParameterCollection;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.DbUtils;
import com.sqlapp.util.FileUtils;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;

public class JdbcHandler {
    private final SqlNode node;
    protected GeneratedKeyHandler generatedKeyHandler = null;
    private Integer queryTimeout = null;
    private Dialect dialect = null;
    private long fetchSizeResult = 0L;
    private long totalFetchProcessTime = 0L;
    private long updateCount = 0L;

    public JdbcHandler(SqlNode node) {
        this.node = node;
    }

    public JdbcHandler(SqlNode node, GeneratedKeyHandler generatedKeyHandler) {
        this.node = node;
        this.generatedKeyHandler = generatedKeyHandler;
    }

    public <T extends JdbcHandler> T execute(Connection connection, Object context, GeneratedKeyHandler generatedKeyHandler) {
        try {
            this.generatedKeyHandler = generatedKeyHandler;
            if (context instanceof ParametersContext) {
                this.doExecute(connection, context);
            } else {
                this.doExecute(connection, context);
            }
            return (T)this;
        }
        catch (SQLException e) {
            this.handleSqlException(e);
            return (T)this;
        }
    }

    public <T extends JdbcHandler> T execute(Connection connection, Object context) {
        return this.execute(connection, context, null);
    }

    public <T extends JdbcHandler> T execute(Connection connection, ParametersContext context) {
        return this.execute(connection, context, null);
    }

    protected SqlNode getNode() {
        return this.node;
    }

    public <T extends JdbcHandler> T execute(Connection connection, SqlParameterCollection sqlParameters, GeneratedKeyHandler generatedKeyHandler) {
        try {
            this.generatedKeyHandler = generatedKeyHandler;
            this.doExecute(connection, sqlParameters);
            return (T)this;
        }
        catch (SQLException e) {
            this.handleSqlException(e);
            return (T)this;
        }
    }

    public <T extends JdbcHandler> T execute(Connection connection, SqlParameterCollection sqlParameters) {
        try {
            this.doExecute(connection, sqlParameters);
        }
        catch (SQLException e) {
            this.handleSqlException(e);
            return (T)this;
        }
        return (T)this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(Connection connection, Object context) throws SQLException {
        StatementSqlParametersHolder statementSqlParametersHolder = null;
        try {
            statementSqlParametersHolder = this.createStatement(connection, context, null);
            this.handlePreparedStatement(statementSqlParametersHolder.getPreparedStatement());
        }
        finally {
            if (statementSqlParametersHolder != null) {
                this.close(statementSqlParametersHolder);
            }
        }
    }

    protected void close(StatementSqlParametersHolder statementSqlParametersHolder) {
        if (statementSqlParametersHolder != null) {
            this.close(statementSqlParametersHolder.getPreparedStatement(), statementSqlParametersHolder.getSqlParameters());
        }
    }

    protected void close(ResultSet resultSet) {
        DbUtils.close(resultSet);
    }

    protected void close(PreparedStatement statement, SqlParameterCollection sqlParameters) {
        DbUtils.close(statement);
        if (sqlParameters != null) {
            FileUtils.close(sqlParameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(Connection connection, SqlParameterCollection sqlParameters) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = this.createStatement(connection, sqlParameters, null);
            this.handlePreparedStatement(statement);
        }
        finally {
            this.close(statement, sqlParameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePreparedStatement(PreparedStatement statement) throws SQLException {
        ExResultSet resultSet = null;
        try {
            if (this.executeStatement(statement)) {
                resultSet = new ExResultSet(statement.getResultSet());
                this.handleResultSet(resultSet);
            } else {
                int updateCount = statement.getUpdateCount();
                if (updateCount != -1) {
                    this.handleUpdate(statement, updateCount);
                    this.handleGeneratedKeys(statement);
                }
            }
            this.handleMoreResults(statement);
        }
        catch (Throwable throwable) {
            DbUtils.close(resultSet);
            throw throwable;
        }
        DbUtils.close(resultSet);
    }

    protected boolean executeStatement(PreparedStatement statement) throws SQLException {
        return statement.execute();
    }

    protected void handleSqlException(SQLException e) {
        throw new RuntimeException(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMoreResults(PreparedStatement statement) throws SQLException {
        boolean moreResults = statement.getMoreResults();
        int updateCount = statement.getUpdateCount();
        while (moreResults) {
            if (updateCount != -1) {
                this.handleUpdate(statement, updateCount);
                this.handleGeneratedKeys(statement);
            } else {
                ExResultSet resultSet = null;
                try {
                    resultSet = new ExResultSet(statement.getResultSet());
                    this.handleResultSet(resultSet);
                    this.close(resultSet);
                }
                catch (Throwable throwable) {
                    this.close(resultSet);
                    throw throwable;
                }
            }
            moreResults = statement.getMoreResults();
            updateCount = statement.getUpdateCount();
        }
    }

    protected void handleResultSet(ExResultSet resultSet) throws SQLException {
        boolean i = false;
        long start = System.currentTimeMillis();
        while (resultSet.next()) {
            this.handleResultSetNext(resultSet);
        }
        long end = System.currentTimeMillis();
        this.fetchSizeResult += 0L;
        this.totalFetchProcessTime += end - start;
    }

    protected void handleResultSetNext(ExResultSet resultSet) throws SQLException {
    }

    protected void handleUpdate(PreparedStatement statement, long updateCount) throws SQLException {
        this.updateCount += updateCount;
    }

    public long getUpdateCount() {
        return this.updateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleGeneratedKeys(PreparedStatement statement) throws SQLException {
        if (this.generatedKeyHandler == null) {
            return;
        }
        ResultSet rs = null;
        try {
            rs = statement.getGeneratedKeys();
            ResultSetMetaData metaData = rs.getMetaData();
            long rowNo = 0L;
            while (rs.next()) {
                for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                    this.generatedKeyHandler.handle(rowNo, new GeneratedKeyHandler.GeneratedKeyInfo(metaData, rs, i));
                }
                ++rowNo;
            }
        }
        finally {
            this.close(rs);
        }
    }

    protected PreparedStatement createStatement(Connection connection, SqlParameterCollection sqlParameters, Integer limit) throws SQLException {
        PreparedStatement statement = this.getStatement(connection, sqlParameters, limit);
        this.setBind(statement, sqlParameters);
        return statement;
    }

    protected StatementSqlParametersHolder createStatement(Connection connection, Object context, Integer limit) throws SQLException {
        SqlParameterCollection sqlParameters = this.createSqlParameterCollection(context);
        PreparedStatement preparedStatement = this.createStatement(connection, sqlParameters, limit);
        return new StatementSqlParametersHolder(preparedStatement, sqlParameters);
    }

    protected SqlParameterCollection createSqlParameterCollection(Object context) {
        return this.node.eval(context);
    }

    protected PreparedStatement getStatement(Connection connection, SqlParameterCollection sqlParameters, Integer limit) throws SQLException {
        PreparedStatement statement = null;
        statement = this.generatedKeyHandler != null ? connection.prepareStatement(sqlParameters.getSql(), 1) : (sqlParameters.getResultSetType() != null || sqlParameters.getResultSetHoldability() != null || sqlParameters.getResultSetConcurrency() != null ? connection.prepareStatement(sqlParameters.getSql(), (sqlParameters.getResultSetType() != null ? sqlParameters.getResultSetType() : ResultSetType.getDefault()).getValue(), (sqlParameters.getResultSetConcurrency() != null ? sqlParameters.getResultSetConcurrency() : ResultSetConcurrency.getDefault()).getValue(), (sqlParameters.getResultSetHoldability() != null ? sqlParameters.getResultSetHoldability() : ResultSetHoldability.getDefault()).getValue()) : connection.prepareStatement(sqlParameters.getSql()));
        if (sqlParameters.getFetchSize() != null) {
            statement.setFetchSize(sqlParameters.getFetchSize());
        } else if (limit != null && limit > 0) {
            if (limit < 1024) {
                statement.setFetchSize(limit);
            } else {
                statement.setFetchSize(1024);
            }
        } else {
            statement.setFetchSize(256);
        }
        return statement;
    }

    protected List<BindParameter> setBind(PreparedStatement statement, SqlParameterCollection sqlParameters) throws SQLException {
        if (this.queryTimeout != null) {
            statement.setQueryTimeout(this.queryTimeout);
        }
        List<BindParameter> list = sqlParameters.getBindParameters();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            BindParameter bindParameter = list.get(i);
            this.setParameter(statement, this.getDialect(), bindParameter, i + 1);
        }
        return list;
    }

    protected void setParameter(PreparedStatement statement, Dialect dialect, BindParameter bindParameter, int index) throws SQLException {
        DataType type = bindParameter.getType();
        Object value = bindParameter.getValue();
        if (dialect != null && bindParameter.getType() != null) {
            DbDataType<?> dbDataType = dialect.getDbDataTypes().getDbType(type);
            dbDataType.getJdbcTypeHandler().setObject(statement, index, value);
        } else if (value instanceof String) {
            if (dialect != null && dialect.recommendsNTypeChar()) {
                statement.setNString(index, (String)value);
            } else {
                statement.setString(index, (String)value);
            }
        } else if (value instanceof Number) {
            if (value instanceof Integer) {
                statement.setInt(index, (Integer)value);
            } else if (value instanceof Long) {
                statement.setLong(index, (Long)value);
            } else if (value instanceof BigDecimal) {
                statement.setBigDecimal(index, (BigDecimal)value);
            } else if (value instanceof Byte) {
                statement.setByte(index, (Byte)value);
            } else if (value instanceof Float) {
                statement.setFloat(index, ((Float)value).floatValue());
            } else if (value instanceof Double) {
                statement.setDouble(index, (Double)value);
            } else {
                statement.setBigDecimal(index, Converters.getDefault().convertObject(value, BigDecimal.class));
            }
        } else if (value instanceof Boolean) {
            statement.setBoolean(index, (Boolean)value);
        } else if (value instanceof byte[]) {
            statement.setBytes(index, (byte[])value);
        } else if (value instanceof Enum) {
            statement.setObject(index, Converters.getDefault().convertString(value));
        } else if (value instanceof Date) {
            statement.setDate(index, (Date)value);
        } else if (value instanceof Time) {
            statement.setTime(index, (Time)value);
        } else if (value instanceof java.util.Date) {
            statement.setTimestamp(index, Converters.getDefault().convertObject(value, Timestamp.class));
        } else if (value instanceof InputStream) {
            statement.setBinaryStream(index, (InputStream)value);
        } else if (value instanceof URL) {
            statement.setURL(index, (URL)value);
        } else {
            statement.setObject(index, value);
        }
    }

    public <T extends JdbcHandler> T setQueryTimeout(Integer queryTimeout) {
        this.queryTimeout = queryTimeout;
        return (T)this;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public long getFetchSizeResult() {
        return this.fetchSizeResult;
    }

    public long getTotalFetchProcessTime() {
        return this.totalFetchProcessTime;
    }

    static class StatementSqlParametersHolder {
        private final PreparedStatement preparedStatement;
        private final SqlParameterCollection sqlParameters;

        StatementSqlParametersHolder(PreparedStatement preparedStatement, SqlParameterCollection sqlParameters) {
            this.preparedStatement = preparedStatement;
            this.sqlParameters = sqlParameters;
        }

        public PreparedStatement getPreparedStatement() {
            return this.preparedStatement;
        }

        public SqlParameterCollection getSqlParameters() {
            return this.sqlParameters;
        }
    }
}

