/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc.sql.node;

import com.sqlapp.jdbc.sql.BindParameter;
import com.sqlapp.jdbc.sql.SqlComparisonOperator;
import com.sqlapp.jdbc.sql.SqlParameterCollection;
import com.sqlapp.jdbc.sql.node.AbstractColumnNode;
import com.sqlapp.jdbc.sql.node.BindVariableNode;
import com.sqlapp.util.AbstractIterator;
import com.sqlapp.util.CommonUtils;
import java.util.Collections;
import java.util.List;

public class BindVariableArrayNode
extends AbstractColumnNode {
    private static final long serialVersionUID = 8430153028619529776L;
    private final BindParameter bindParameter = new BindParameter();
    static final int SPLIT_SIZE = 1000;

    @Override
    public void setExpression(String expression) {
        this.setParameterDefinition(BindVariableNode.parse(this.bindParameter, expression));
        if (this.getParameterDefinition() != null) {
            this.expression = this.getParameterDefinition().getName();
        }
    }

    @Override
    public boolean eval(Object context, SqlParameterCollection sqlParameters) {
        Object val = this.evalExpression(this.bindParameter.getName(), context);
        this.addValues(sqlParameters, context, val);
        return true;
    }

    private void addValues(SqlParameterCollection sqlParameters, Object context, Object val) {
        final BindParameter originalParameter = this.bindParameter;
        String operatorText = this.getColumnOperator(this.bindParameter.getName(), context);
        final List<BindParameter> parameters = CommonUtils.list();
        final SqlComparisonOperator operator = SqlComparisonOperator.parse(operatorText);
        AbstractIterator<Object> itr = new AbstractIterator<Object>(this.getEvaluator(), this.bindParameter.getName()){

            @Override
            protected void handle(Object obj, int index) {
                BindParameter parameter = originalParameter.clone();
                if (operator != null) {
                    parameter.setValue(operator.getConverter().apply(obj));
                } else {
                    parameter.setValue(obj);
                }
                parameters.add(parameter);
            }
        };
        try {
            itr.execute(val);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (parameters.size() > 1) {
            Collections.sort(parameters);
        }
        this.buildColumnOperator(operatorText, parameters, sqlParameters);
    }

    private void buildColumnOperator(String operatorText, List<BindParameter> parameters, SqlParameterCollection sqlParameters) {
        SqlComparisonOperator operator = SqlComparisonOperator.parse(operatorText);
        if (parameters.size() > 1) {
            if (operator != null && operator.allowMultiple()) {
                this.buildMultipleColumnOperator(operator, parameters, sqlParameters);
            } else if (operator != null && operator.getMultipleOperator() != null) {
                operator = operator.getMultipleOperator();
                this.buildMultipleColumnOperator(operator, parameters, sqlParameters);
            } else if (operator != null && operator.getParameterCount() != null) {
                if (operator.getOperaterElements() != null) {
                    String conjuction = operator.conjuction();
                    sqlParameters.addSql(" ( ");
                    if (parameters.size() != operator.getOperaterElements().length) {
                        throw new IllegalArgumentException("name=" + this.getColumn() + ",parameter.size=" + parameters.size() + ", acceptableSize=" + operator.getOperaterElements().length);
                    }
                    for (int i = 0; i < operator.getOperaterElements().length; ++i) {
                        sqlParameters.addSql(conjuction, i > 0);
                        SqlComparisonOperator op = operator.getOperaterElements()[i];
                        this.addColumnOperator(sqlParameters, op.getSqlValue());
                        BindParameter param = parameters.get(i);
                        sqlParameters.add(param);
                    }
                    sqlParameters.addSql(" ) ");
                } else {
                    this.addColumnOperator(sqlParameters, operator.getSqlValue());
                    String conjuction = operator.conjuction();
                    for (int i = 0; i < parameters.size(); ++i) {
                        sqlParameters.addSql(conjuction, i > 0);
                        BindParameter param = parameters.get(i);
                        sqlParameters.add(param);
                    }
                }
            } else {
                if (operator != null && operator.isNegationOperator() && operator.reverse() != null) {
                    operator = operator.reverse();
                    sqlParameters.addSql(" NOT ( ");
                } else {
                    sqlParameters.addSql(" ( ");
                }
                for (int i = 0; i < parameters.size(); ++i) {
                    sqlParameters.addSql(" OR ", i > 0);
                    if (operator == null) {
                        this.addColumnOperator(sqlParameters, operatorText);
                    } else {
                        this.addColumnOperator(sqlParameters, operator.getSqlValue());
                    }
                    BindParameter param = parameters.get(i);
                    sqlParameters.add(param);
                }
                sqlParameters.addSql(" ) ");
            }
        } else if (parameters.size() == 1) {
            if (operator == null) {
                this.addColumnOperator(sqlParameters, operatorText);
                sqlParameters.add(CommonUtils.first(parameters));
            } else {
                this.addColumnOperator(sqlParameters, operator.getSqlValue());
                if (operator.allowMultiple()) {
                    sqlParameters.addSql('(');
                    sqlParameters.addAll(parameters);
                    sqlParameters.addSql(')');
                } else {
                    sqlParameters.add(CommonUtils.first(parameters));
                }
            }
        }
    }

    private void buildMultipleColumnOperator(SqlComparisonOperator operator, List<BindParameter> parameters, SqlParameterCollection sqlParameters) {
        if (parameters.size() <= 1000) {
            this.addColumnOperator(sqlParameters, operator.getSqlValue());
            sqlParameters.addSql('(');
            sqlParameters.addAll(parameters);
            sqlParameters.addSql(')');
        } else {
            List<List<BindParameter>> splits = this.splitBindParameters(parameters, 1000);
            sqlParameters.addSql(" ( ");
            for (int i = 0; i < splits.size(); ++i) {
                if (i > 0) {
                    sqlParameters.addSql(" OR ");
                }
                this.addColumnOperator(sqlParameters, operator.getSqlValue());
                sqlParameters.addSql('(');
                List<BindParameter> params = splits.get(i);
                sqlParameters.addAll(params);
                sqlParameters.addSql(')');
            }
            sqlParameters.addSql(" ) ");
        }
    }

    private List<List<BindParameter>> splitBindParameters(List<BindParameter> parameters, int size) {
        List<List<BindParameter>> result = CommonUtils.list();
        List current = CommonUtils.list();
        result.add(current);
        for (int i = 0; i < parameters.size(); ++i) {
            BindParameter parameter = parameters.get(i);
            current.add(parameter);
            if (current.size() < size) continue;
            current = CommonUtils.list();
            result.add(current);
        }
        return result;
    }

    @Override
    public BindVariableArrayNode clone() {
        return (BindVariableArrayNode)super.clone();
    }
}

