/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc.sql.node;

import com.sqlapp.data.DataMessageReader;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.exceptions.ExpressionExecutionException;
import com.sqlapp.jdbc.sql.BindParameter;
import com.sqlapp.jdbc.sql.SqlParameterCollection;
import com.sqlapp.jdbc.sql.SqlRegistry;
import com.sqlapp.util.eval.CachedEvaluator;
import com.sqlapp.util.eval.mvel.CachedMvelEvaluator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public abstract class Node
implements Comparator<Node>,
Serializable,
Cloneable,
Comparable<Node> {
    private static final long serialVersionUID = 2889174869094179897L;
    private List<Node> childNodeList = new ArrayList<Node>();
    private String sql = null;
    private transient SqlRegistry sqlRegistry = null;
    private Node parent = null;
    private transient CachedEvaluator evaluator = CachedMvelEvaluator.getInstance();
    private int nestedLevel = 0;
    private int index = 0;

    public List<Node> getChildNodes() {
        return this.childNodeList;
    }

    public void addChildNode(Node node) {
        this.childNodeList.add(node);
    }

    @Override
    public int compare(Node x, Node y) {
        if (x.getIndex() == y.index) {
            return 0;
        }
        if (x.getIndex() > y.index) {
            return 1;
        }
        return -1;
    }

    public SqlParameterCollection eval(Object context) {
        return this.eval(context, (Dialect)null);
    }

    public SqlParameterCollection eval(Object context, Dialect dialect) {
        SqlParameterCollection sqlParameters = new SqlParameterCollection(dialect);
        this.eval(context, sqlParameters);
        return sqlParameters;
    }

    public void reEval(Object context, SqlParameterCollection sqlParameters) {
        List<BindParameter> bindParameters = sqlParameters.getBindParameters();
        int size = bindParameters.size();
        for (int i = 0; i < size; ++i) {
            BindParameter bindParameter = bindParameters.get(i);
            Object value = this.evalExpression(bindParameter.getName(), context);
            bindParameter.setValue(value);
        }
    }

    public abstract boolean eval(Object var1, SqlParameterCollection var2);

    protected Object evalExpression(String expression, Object context) {
        try {
            return this.getEvaluator().getEvalExecutor(expression).eval(context);
        }
        catch (ExpressionExecutionException e) {
            throw this.handleExceptrion(e);
        }
    }

    protected ExpressionExecutionException handleExceptrion(Exception e) {
        String message = DataMessageReader.getInstance().getMessage("ESQL00003", this.getLine(), this.getOffset(), this.getSql());
        ExpressionExecutionException ee = new ExpressionExecutionException(message, e);
        throw ee;
    }

    protected CachedEvaluator getEvaluator() {
        if (this.evaluator == null) {
            this.evaluator = CachedMvelEvaluator.getInstance();
        }
        return this.evaluator;
    }

    protected void setEvaluator(CachedEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public int getNestedLevel() {
        return this.nestedLevel;
    }

    public void setNestedLevel(int nestedLevel) {
        this.nestedLevel = nestedLevel;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public int getLine() {
        if (this.getIndex() == 0) {
            return 0;
        }
        if (this.getIndex() <= this.sql.length()) {
            String sub = this.sql.substring(0, this.getIndex() - 1);
            return sub.split("[\\n]").length - 1;
        }
        return this.sql.split("[\\n]").length - 1;
    }

    protected SqlRegistry getSqlRegistry() {
        if (this.getParent() != null) {
            return this.getParent().getSqlRegistry();
        }
        return this.sqlRegistry;
    }

    public void setSqlRegistry(SqlRegistry sqlRegistry) {
        this.sqlRegistry = sqlRegistry;
    }

    public int getOffset() {
        int i = 0;
        int start = this.getIndex();
        if (start >= this.getSql().length()) {
            start = this.getSql().length() - 1;
        }
        for (i = start; i >= 0 && this.getSql().charAt(i) != '\n'; --i) {
        }
        return start - i - 1;
    }

    public Node clone() {
        try {
            Node clone = (Node)super.clone();
            if (this.childNodeList != null) {
                clone.childNodeList.clear();
                for (Node node : this.childNodeList) {
                    clone.addChildNode(node.clone());
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    @Override
    public int compareTo(Node o) {
        if (this.getIndex() > o.getIndex()) {
            return 1;
        }
        if (this.getIndex() < o.getIndex()) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return this.getSql();
    }
}

