/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc.sql.node;

import com.sqlapp.jdbc.sql.ResultSetConcurrency;
import com.sqlapp.jdbc.sql.ResultSetHoldability;
import com.sqlapp.jdbc.sql.ResultSetType;
import com.sqlapp.jdbc.sql.node.AbstractCommentNodeFactory;
import com.sqlapp.jdbc.sql.node.QueryNode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueryNodeFactory
extends AbstractCommentNodeFactory<QueryNode> {
    protected static final Pattern[] MATCH_PATTERNS = new Pattern[]{Pattern.compile("(?<value>/\\*query[\\s]*\\((?<expression>[^)]+?)\\)[\\s]*\\*/)")};

    @Override
    public QueryNode newInstance() {
        return new QueryNode();
    }

    @Override
    protected Pattern[] getMatchPatterns() {
        return MATCH_PATTERNS;
    }

    @Override
    protected void setNodeValue(QueryNode node, Matcher matcher) {
        String[] params;
        super.setNodeValue(node, matcher);
        for (String param : params = node.getExpression().split("\\s*,\\s*")) {
            String[] pair = param.split("\\s*=\\s*");
            if (pair.length != 2) continue;
            if ("fetchSize".equalsIgnoreCase(pair[0])) {
                node.setFetchSize(Integer.valueOf(pair[1]));
                continue;
            }
            if ("resultSetType".equalsIgnoreCase(pair[0])) {
                node.setResultSetType(ResultSetType.parse(pair[1]));
                continue;
            }
            if ("resultSetConcurrency".equalsIgnoreCase(pair[0])) {
                node.setResultSetConcurrency(ResultSetConcurrency.parse(pair[1]));
                continue;
            }
            if (!"resultSetHoldability".equalsIgnoreCase(pair[0])) continue;
            node.setResultSetHoldability(ResultSetHoldability.parse(pair[1]));
        }
    }
}

