/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.sqlapp.data.converter.Converter;
import com.sqlapp.data.converter.Converters;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractJsonConverter<T> {
    protected static final Logger LOGGER = LogManager.getLogger(AbstractJsonConverter.class);
    private boolean utc = true;
    protected static final Converter<ZonedDateTime> converter = (Converter)Converters.createDefaultZonedDateTimeConverter().setFormat(DateTimeFormatter.ISO_INSTANT);
    private static final ZoneId UTC_ZONE_ID = ZoneId.of("Z");
    private static Converters converters = Converters.getDefault();

    public AbstractJsonConverter() {
    }

    public AbstractJsonConverter(boolean utc) {
        this.utc = utc;
    }

    private static ZonedDateTime toUtc(ZonedDateTime dateTime) {
        return dateTime.withZoneSameInstant(UTC_ZONE_ID);
    }

    public abstract T getObjectMapper();

    protected String formatUtc(ZonedDateTime dateTime) {
        if (this.utc) {
            return converter.convertString(AbstractJsonConverter.toUtc(dateTime));
        }
        return converter.convertString(dateTime);
    }

    protected String format(ZonedDateTime dateTime) {
        return converter.convertString(dateTime);
    }

    protected String format(Date date) {
        ZonedDateTime dateTime = converters.convertObject(date, ZonedDateTime.class);
        return this.formatUtc(dateTime);
    }

    protected <S extends Temporal> String format(S date) {
        ZonedDateTime dateTime = converters.convertObject(date, ZonedDateTime.class);
        return this.formatUtc(dateTime);
    }

    protected String format(Calendar calendar) {
        ZonedDateTime dateTime = converters.convertObject(calendar, ZonedDateTime.class);
        return this.format(dateTime);
    }

    protected static Date toDate(String text) {
        if (text == null) {
            return null;
        }
        ZonedDateTime dateTime = AbstractJsonConverter.toDateTime(text);
        Date date = converters.convertObject(dateTime, Date.class);
        return date;
    }

    protected static Calendar toCalendar(String text) {
        if (text == null) {
            return null;
        }
        ZonedDateTime dateTime = AbstractJsonConverter.toDateTime(text);
        Calendar date = converters.convertObject(dateTime, Calendar.class);
        return date;
    }

    protected static ZonedDateTime toDateTime(String text) {
        return converter.convertObject(text);
    }

    public abstract String toJsonString(Object var1);

    public abstract <S> S fromJsonString(String var1, Class<S> var2);

    public abstract <S> S fromJsonString(InputStream var1, TypeReference<S> var2);

    public abstract <S> S fromJsonString(String var1, TypeReference<S> var2);

    public abstract <S> S fromJsonString(InputStream var1, Class<S> var2);

    public abstract <S> S fromJsonString(File var1, Class<S> var2);

    public abstract <S> S fromJsonString(File var1, TypeReference<S> var2);

    protected String inputStreamToString(InputStream in) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));){
            StringBuilder buf = new StringBuilder(128);
            String str = reader.readLine();
            if (str != null) {
                buf.append(str);
                while ((str = reader.readLine()) != null) {
                    buf.append("\n");
                    buf.append(str);
                }
            }
            String string = buf.toString();
            return string;
        }
    }

    protected boolean isUtc() {
        return this.utc;
    }

    public abstract void writeJsonValue(OutputStream var1, Object var2);

    public abstract void writeJsonValue(File var1, Object var2);

    public abstract void setFailOnUnknownProperties(boolean var1);
}

