/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.DbInfo;
import com.sqlapp.data.schemas.ReferenceColumn;
import com.sqlapp.util.AbstractStringMap;
import com.sqlapp.util.CaseInsensitiveMap;
import com.sqlapp.util.CaseInsensitiveSet;
import com.sqlapp.util.DateUtils;
import com.sqlapp.util.DoubleKeyMap;
import com.sqlapp.util.LowerMap;
import com.sqlapp.util.LowerSet;
import com.sqlapp.util.QuadKeyMap;
import com.sqlapp.util.TripleKeyMap;
import com.sqlapp.util.UpperMap;
import com.sqlapp.util.UpperSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;

public final class CommonUtils {
    public static final int LEN_1KB;
    public static final int LEN_64KB;
    public static final int LEN_1MB;
    public static final int LEN_16MB;
    public static final int LEN_1GB;
    public static final long LEN_2GB;
    public static final long LEN_4GB;
    public static final int SHORT_SIZE = 2;
    public static final int INT16_SIZE = 2;
    public static final int INT_SIZE = 4;
    public static final int INT32_SIZE = 4;
    public static final int LONG_SIZE = 8;
    public static final int INT64_SIZE = 8;
    public static final int INT128_SIZE = 16;
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_CLASS_MAP;
    private static Map<String, String> ENV_MAP;
    private static ConcurrentMap<String, Class<?>> classCache;
    private static ConcurrentMap<String, Pattern> compiledPatternMap;
    private static ConcurrentMap<String, ConcurrentMap<Integer, Pattern>> compiledOptionPatternMap;
    private static final Map<String, Locale> LOCALE_CACHE;
    private static final Map<Class<?>, Map<Class<?>, Boolean>> ASSIGNABLE_FROM_CACHE;

    private CommonUtils() {
    }

    private static void setPrimitiveWrapperMapping(Class<?> clazz1, Class<?> clazz2) {
        PRIMITIVE_WRAPPER_CLASS_MAP.put(clazz1, clazz2);
        PRIMITIVE_WRAPPER_CLASS_MAP.put(clazz2, clazz1);
    }

    private static void initializeEnv() {
        HashMap<String, String> map = new HashMap<String, String>();
        Properties prop = System.getProperties();
        for (Object obj : prop.keySet()) {
            String key = (String)obj;
            map.put(key, prop.getProperty(key));
        }
        map.putAll(System.getenv());
        ENV_MAP = Collections.unmodifiableMap(map);
    }

    public static final Map<String, String> getSystemEnv() {
        return ENV_MAP;
    }

    public static <T> T cast(Object obj) {
        return (T)obj;
    }

    @SafeVarargs
    public static <T> List<T> list(T ... args) {
        int size = args.length;
        List<T> result = CommonUtils.list(size);
        for (int i = 0; i < size; ++i) {
            result.add(args[i]);
        }
        return result;
    }

    public static <T> List<T> list(Collection<T> c) {
        List<T> result = CommonUtils.list(c.size());
        result.addAll(c);
        return result;
    }

    public static <T> List<T> list(Iterable<T> itr) {
        ArrayList<T> list = new ArrayList<T>();
        for (T obj : itr) {
            list.add(obj);
        }
        return list;
    }

    public static <T> Set<T> set(Iterable<T> itr) {
        HashSet<T> set = new HashSet<T>();
        for (T obj : itr) {
            set.add(obj);
        }
        return set;
    }

    public static <T> Set<T> linkedSet(Iterable<T> itr) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (T obj : itr) {
            set.add(obj);
        }
        return set;
    }

    public static <T> List<T> list(T arg) {
        List<T> result = CommonUtils.list();
        result.add(arg);
        return result;
    }

    public static <T> List<T> list(T arg1, T arg2) {
        List<T> result = CommonUtils.list();
        result.add(arg1);
        result.add(arg2);
        return result;
    }

    @SafeVarargs
    public static <T> void add(List<T> list, T ... args) {
        int size = args.length;
        for (int i = 0; i < size; ++i) {
            list.add(args[i]);
        }
    }

    public static <T> void add(List<T> list, T arg) {
        list.add(arg);
    }

    public static <T> List<T> list(List<T> args) {
        int size = args.size();
        List<T> result = CommonUtils.list(size);
        for (int i = 0; i < size; ++i) {
            result.add(args.get(i));
        }
        return result;
    }

    public static <T> List<T> list() {
        return new ArrayList();
    }

    public static <T> List<T> list(int capacity) {
        return new ArrayList(capacity);
    }

    public static <S, T> Map<S, T> map() {
        return new HashMap();
    }

    public static <S, T> ConcurrentMap<S, T> concurrentMap() {
        return new ConcurrentHashMap();
    }

    public static <S extends Enum<S>, T> Map<S, T> enumMap(Class<S> clazz) {
        return new EnumMap(clazz);
    }

    public static <S, T> SortedMap<S, T> treeMap() {
        return new TreeMap();
    }

    public static <S> Set<S> treeSet() {
        return new TreeSet();
    }

    @SafeVarargs
    public static <T> Set<T> treeSet(T ... args) {
        TreeSet<T> result = new TreeSet<T>();
        for (T arg : args) {
            result.add(arg);
        }
        return result;
    }

    public static <S, T> Map<S, T> map(int capacity) {
        return new HashMap(capacity);
    }

    public static <S, T> Map<S, T> map(Map<S, T> map) {
        return new HashMap<S, T>(map);
    }

    public static <S, T> Map<S, T> map(int capacity, float loadFactor) {
        return new HashMap(capacity, loadFactor);
    }

    public static <S, T> ConcurrentMap<S, T> concurrentMap(int capacity) {
        return new ConcurrentHashMap(capacity);
    }

    public static <S, T> Map<S, T> linkedMap() {
        return new LinkedHashMap();
    }

    public static <S, T> Map<S, T> linkedMap(Map<S, T> map) {
        return new LinkedHashMap<S, T>(map);
    }

    public static <S, T> Map<S, T> linkedMap(int capacity) {
        return new LinkedHashMap(capacity);
    }

    public static <S, T> Map<S, T> linkedMap(int capacity, float loadFactor) {
        return new LinkedHashMap(capacity, loadFactor);
    }

    public static <S, T, U> DoubleKeyMap<S, T, U> doubleKeyMap() {
        return new DoubleKeyMap();
    }

    public static <S, T, U, V> TripleKeyMap<S, T, U, V> tripleKeyMap() {
        return new TripleKeyMap();
    }

    public static <S, T, U, V, W> QuadKeyMap<S, T, U, V, W> quadKeyMap() {
        return new QuadKeyMap();
    }

    public static <T> Map<String, T> upperMap() {
        return new UpperMap();
    }

    public static <T> Map<String, T> upperMap(int capacity) {
        return new UpperMap(capacity);
    }

    public static <T> Map<String, T> lowerMap() {
        return new LowerMap();
    }

    public static <T> Map<String, T> lowerLinkedMap() {
        return new LowerMap(new LinkedHashMap());
    }

    public static <T> Map<String, T> lowerLinkedMap(int capacity) {
        return new LowerMap(new LinkedHashMap(capacity));
    }

    public static <T> Map<String, T> lowerMap(int capacity) {
        return new LowerMap(capacity);
    }

    public static <T> Map<String, T> upperLinkedMap() {
        return new UpperMap(new LinkedHashMap());
    }

    public static <T> Map<String, T> upperSortedMap() {
        return new UpperMap(new TreeMap());
    }

    public static <T> Map<String, T> upperLinkedMap(int capacity) {
        return new UpperMap(new LinkedHashMap(capacity));
    }

    public static <T> Map<String, T> caseInsensitiveMap() {
        return new CaseInsensitiveMap();
    }

    public static <T> Map<String, T> caseInsensitiveMap(int capacity) {
        return new CaseInsensitiveMap(capacity);
    }

    public static <T> Map<String, T> caseInsensitiveLinkedMap() {
        return new CaseInsensitiveMap(new LinkedHashMap());
    }

    public static Set<String> caseInsensitiveLinkedSet() {
        return new CaseInsensitiveSet(new LinkedHashSet<String>());
    }

    public static <T> Map<String, T> caseInsensitiveLinkedMap(int capacity) {
        return new CaseInsensitiveMap(new LinkedHashMap(capacity));
    }

    public static <T> Map<String, T> caseInsensitiveTreeMap() {
        return new CaseInsensitiveMap(new TreeMap());
    }

    public static <T> Map<String, T> caseInsensitiveTreeMap(Map<String, T> m) {
        return new CaseInsensitiveMap<T>(new TreeMap<String, T>(m));
    }

    public static <T> Set<T> set(int capacity) {
        return new HashSet(capacity);
    }

    public static <T> Set<T> set(int capacity, float loadFactor) {
        return new HashSet(capacity, loadFactor);
    }

    public static <S extends Enum<S>> Set<S> enumSetOf(S enm) {
        return EnumSet.of(enm);
    }

    @SafeVarargs
    public static <T> Set<T> set(T ... args) {
        int size = args.length;
        Set<int> result = CommonUtils.set(args.length);
        for (int i = 0; i < size; ++i) {
            result.add((int)args[i]);
        }
        return result;
    }

    public static <T> Set<T> set(T arg) {
        Set<T> result = CommonUtils.set();
        result.add(arg);
        return result;
    }

    public static Set<String> lowerSet() {
        LowerSet result = new LowerSet();
        return result;
    }

    public static Set<String> lowerSet(String ... args) {
        int size = args.length;
        LowerSet result = new LowerSet(size);
        for (int i = 0; i < size; ++i) {
            result.add(args[i]);
        }
        return result;
    }

    public static Set<String> upperSet(String ... args) {
        int size = args.length;
        UpperSet result = new UpperSet(size);
        for (int i = 0; i < size; ++i) {
            result.add(args[i]);
        }
        return result;
    }

    public static Set<String> upperSet() {
        UpperSet result = new UpperSet();
        return result;
    }

    public static <T> Set<T> set() {
        HashSet result = new HashSet();
        return result;
    }

    public static <T> Set<T> set(Collection<T> args) {
        HashSet<T> result = new HashSet<T>();
        for (T arg : args) {
            result.add(arg);
        }
        return result;
    }

    public static <T> Set<T> set(List<T> args) {
        HashSet<T> result = new HashSet<T>();
        for (T arg : args) {
            result.add(arg);
        }
        return result;
    }

    public static <T> Set<T> linkedSet() {
        LinkedHashSet result = new LinkedHashSet();
        return result;
    }

    public static <T> Set<T> linkedSet(int capacity) {
        LinkedHashSet result = new LinkedHashSet(capacity);
        return result;
    }

    public static <T> Set<T> linkedSet(Collection<T> set) {
        LinkedHashSet<T> result = new LinkedHashSet<T>(set);
        return result;
    }

    @SafeVarargs
    public static <T> Set<T> linkedSet(T ... args) {
        LinkedHashSet<T> result = new LinkedHashSet<T>(args.length);
        for (T arg : args) {
            result.add(arg);
        }
        return result;
    }

    public static Set<String> upperLinkedSet() {
        UpperSet result = new UpperSet(new LinkedHashSet<String>());
        return result;
    }

    public static Set<String> upperTreeSet() {
        UpperSet result = new UpperSet(new TreeSet<String>());
        return result;
    }

    @SafeVarargs
    public static <T> T[] array(T ... args) {
        return args;
    }

    public static <T> T coalesce(Object ... args) {
        for (Object arg : args) {
            if (arg == null) continue;
            return (T)arg;
        }
        return null;
    }

    public static <T> T coalesce(T arg1, T arg2) {
        return arg1 == null ? arg2 : arg1;
    }

    public static <T> T coalesce(T arg1, T arg2, T arg3) {
        return arg1 == null ? (arg2 == null ? arg3 : arg2) : arg1;
    }

    public static <T> T coalesce(T arg1, T arg2, T arg3, T arg4) {
        return arg1 == null ? (arg2 == null ? (arg3 == null ? arg4 : arg3) : arg2) : arg1;
    }

    public static <T> T coalesce(Collection<T> args) {
        for (T arg : args) {
            if (arg == null) continue;
            return arg;
        }
        return null;
    }

    @SafeVarargs
    public static <T> T notEmpty(T ... args) {
        for (T arg : args) {
            if (CommonUtils.isEmpty(arg)) continue;
            return arg;
        }
        return null;
    }

    public static <T> T notEmpty(T arg1, T arg2) {
        if (CommonUtils.isEmpty(arg1)) {
            return arg2;
        }
        return arg1;
    }

    public static <T> T notEmpty(T arg1, T arg2, T arg3) {
        if (CommonUtils.isEmpty(arg1)) {
            return CommonUtils.notEmpty(arg2, arg3);
        }
        return arg1;
    }

    public static <T> T notEmpty(Collection<T> args) {
        for (T arg : args) {
            if (CommonUtils.isEmpty(arg)) continue;
            return arg;
        }
        return null;
    }

    public static <T> T coalesce(List<T> args) {
        int size = args.size();
        for (int i = 0; i < size; ++i) {
            T arg = args.get(i);
            if (arg == null) continue;
            return arg;
        }
        return null;
    }

    public static <T> List<T> unique(List<T> list) {
        if (list == null) {
            return list;
        }
        List result = (List)CommonUtils.cast(CommonUtils.newInstance(list));
        Set<T> set = CommonUtils.set();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T arg = list.get(i);
            if (set.contains(arg)) continue;
            result.add(arg);
            set.add(arg);
        }
        return result;
    }

    public static String[] unique(String[] args) {
        if (args == null) {
            return args;
        }
        Set<String> set = CommonUtils.linkedSet();
        return set.toArray(new String[0]);
    }

    @SafeVarargs
    public static <T> List<T> plus(List<T> list1, T ... args) {
        if (args == null) {
            return list1;
        }
        List<T> result = CommonUtils.list(list1.size());
        Collections.copy(result, list1);
        for (T arg : args) {
            result.add(arg);
        }
        return result;
    }

    @SafeVarargs
    public static <T> List<T> union(List<T> ... lists) {
        List<T> result = CommonUtils.list();
        Set<T> set = CommonUtils.set();
        for (List<T> current : lists) {
            int csize = current.size();
            for (int j = 0; j < csize; ++j) {
                T arg = current.get(j);
                if (set.contains(arg)) continue;
                result.add(arg);
                set.add(arg);
            }
        }
        return result;
    }

    @SafeVarargs
    public static <T> Set<T> union(Set<T> ... sets) {
        if (sets == null || sets.length == 0) {
            return CommonUtils.set();
        }
        Set result = (Set)CommonUtils.cast(CommonUtils.newInstance(CommonUtils.first(sets)));
        for (Set<T> set : sets) {
            for (T obj : set) {
                set.add(obj);
            }
        }
        return result;
    }

    public static <T> List<T> minus(List<T> list1, List<T> list2) {
        if (list1 == null || list2 == null) {
            return list1;
        }
        List result = (List)CommonUtils.cast(CommonUtils.newInstance(list1));
        int size1 = list1.size();
        Set<T> set = CommonUtils.set(list2);
        for (int i = 0; i < size1; ++i) {
            T arg = list1.get(i);
            if (set.contains(arg)) continue;
            result.add(arg);
        }
        return result;
    }

    public static <T> List<T> minus(List<T> list1, Collection<T> args) {
        if (list1 == null || args == null) {
            return list1;
        }
        List result = (List)CommonUtils.cast(CommonUtils.newInstance(list1));
        int size1 = list1.size();
        Set<T> set = CommonUtils.set(args);
        for (int i = 0; i < size1; ++i) {
            T arg = list1.get(i);
            if (set.contains(arg)) continue;
            result.add(arg);
        }
        return result;
    }

    public static <T> List<T> minus(List<T> list1, T[] args) {
        if (list1 == null || args == null) {
            return list1;
        }
        List result = (List)CommonUtils.cast(CommonUtils.newInstance(list1));
        int size1 = list1.size();
        Set<T[]> set = CommonUtils.set(args);
        for (int i = 0; i < size1; ++i) {
            T arg = list1.get(i);
            if (set.contains(arg)) continue;
            result.add(arg);
        }
        return result;
    }

    public static <T> Class<T> classForName(String className) {
        Class<?> result = CommonUtils.classForNameInternal(className);
        return result;
    }

    protected static Class<?> classForNameInternal(String className) {
        Class<?> result = (Class<?>)classCache.get(className);
        if (result != null) {
            return result;
        }
        try {
            result = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
            Class<?> oldValue = classCache.putIfAbsent(className, result);
            return oldValue == null ? result : oldValue;
        }
        catch (ClassNotFoundException e) {
            try {
                result = Class.forName(className);
                Class<?> oldValue = classCache.putIfAbsent(className, result);
                return oldValue == null ? result : oldValue;
            }
            catch (ClassNotFoundException e1) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... parameterTypes) {
        Constructor<?> constructor;
        try {
            constructor = clazz.getConstructor(parameterTypes);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        return constructor;
    }

    public static Object newInstance(Object ... args) {
        Class<?> clazz = CommonUtils.coalesce(args).getClass();
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object newInstance(Object arg) {
        if (arg instanceof ArrayList) {
            return CommonUtils.list(((List)arg).size());
        }
        Class<?> clazz = arg.getClass();
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<?, ?> newInstance(Map<?, ?> arg) {
        if (arg instanceof HashMap) {
            return new HashMap(arg.size());
        }
        if (arg instanceof CaseInsensitiveMap) {
            Object caseInsensitiveMap = ((CaseInsensitiveMap)arg).clone();
            ((CaseInsensitiveMap)caseInsensitiveMap).clear();
            return caseInsensitiveMap;
        }
        if (arg instanceof ConcurrentHashMap) {
            return new ConcurrentHashMap(arg.size());
        }
        if (arg instanceof WeakHashMap) {
            return new WeakHashMap(arg.size());
        }
        if (arg instanceof AbstractStringMap) {
            return ((AbstractStringMap)arg).newInstance();
        }
        if (arg instanceof EnumMap) {
            Object map = ((EnumMap)arg).clone();
            map.clear();
            return map;
        }
        Class<?> clazz = arg.getClass();
        try {
            return (Map)CommonUtils.cast(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @SafeVarargs
    public static <S, T> List<T> getValues(Map<S, T> map, S ... args) {
        if (map == null) {
            return null;
        }
        List<T> list = CommonUtils.list();
        for (S arg : args) {
            if (arg == null || !map.containsKey(arg)) continue;
            list.add(map.get(arg));
        }
        return list;
    }

    public static <S, T> List<T> getValues(Map<S, T> map, Collection<S> args) {
        if (map == null) {
            return null;
        }
        List<T> list = CommonUtils.list(args.size());
        for (S arg : args) {
            if (arg == null || !map.containsKey(arg)) continue;
            list.add(map.get(arg));
        }
        return list;
    }

    public static <S, T> List<T> getValues(Map<S, T> map, List<S> args) {
        if (map == null) {
            return null;
        }
        List<T> list = CommonUtils.list(args.size());
        int size = args.size();
        for (int i = 0; i < size; ++i) {
            S arg = args.get(i);
            if (arg == null || !map.containsKey(arg)) continue;
            list.add(map.get(arg));
        }
        return list;
    }

    public static <T> T first(List<T> args) {
        if (args == null) {
            return null;
        }
        if (args.size() == 0) {
            return null;
        }
        return args.get(0);
    }

    public static <S, T> Map.Entry<S, T> first(Map<S, T> args) {
        if (args == null) {
            return null;
        }
        if (args.size() == 0) {
            return null;
        }
        Iterator<Map.Entry<S, T>> iterator = args.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<S, T> entry = iterator.next();
            return entry;
        }
        return null;
    }

    public static <T> T first(Collection<T> args) {
        if (args == null) {
            return null;
        }
        if (args.size() == 0) {
            return null;
        }
        Iterator<T> iterator = args.iterator();
        if (iterator.hasNext()) {
            T arg = iterator.next();
            return arg;
        }
        return null;
    }

    public static <T> T last(List<T> args) {
        if (args == null) {
            return null;
        }
        if (args.size() == 0) {
            return null;
        }
        return args.get(args.size() - 1);
    }

    public static <T> T first(T[] args) {
        if (args == null) {
            return null;
        }
        if (args.length == 0) {
            return null;
        }
        return args[0];
    }

    public static <T> T get(T[] args, int pos) {
        if (args == null) {
            return null;
        }
        if (args.length == 0) {
            return null;
        }
        if (args.length <= pos) {
            return null;
        }
        if (pos < 0) {
            return null;
        }
        return args[pos];
    }

    public static <T> T last(T[] args) {
        if (args == null) {
            return null;
        }
        if (args.length == 0) {
            return null;
        }
        return args[args.length - 1];
    }

    public static long min(long arg1, long arg2) {
        return arg1 < arg2 ? arg1 : arg2;
    }

    public static long min(long arg1, long arg2, long arg3) {
        return arg1 < arg2 ? (arg1 < arg3 ? arg1 : arg3) : (arg2 < arg3 ? arg2 : arg3);
    }

    public static Long min(Long arg1, Long arg2, Long arg3) {
        return CommonUtils.min(CommonUtils.min(arg1, arg2), arg3);
    }

    public static long min(long arg1, long arg2, long arg3, long arg4) {
        return CommonUtils.min(CommonUtils.min(arg1, arg2), CommonUtils.min(arg3, arg4));
    }

    public static Long min(Long arg1, Long arg2, Long arg3, Long arg4) {
        return CommonUtils.min(CommonUtils.min(arg1, arg2), CommonUtils.min(arg3, arg4));
    }

    public static long min(long arg1, long arg2, long arg3, long arg4, long arg5) {
        return CommonUtils.min(CommonUtils.min(arg1, arg2), CommonUtils.min(arg3, arg4, arg5));
    }

    public static Long min(Long arg1, Long arg2, Long arg3, Long arg4, Long arg5) {
        return CommonUtils.min(CommonUtils.min(CommonUtils.min(arg1, arg2), CommonUtils.min(arg3, arg4)), arg5);
    }

    public static int min(int arg1, int arg2) {
        return arg1 < arg2 ? arg1 : arg2;
    }

    public static Integer min(Integer arg1, Integer arg2) {
        if (arg1 == null) {
            if (arg2 == null) {
                return null;
            }
            return arg2;
        }
        if (arg2 == null) {
            return arg1;
        }
        return CommonUtils.min((int)arg1, (int)arg2);
    }

    public static int min(int arg1, int arg2, int arg3) {
        return arg1 < arg2 ? (arg1 < arg3 ? arg1 : arg3) : (arg2 < arg3 ? arg2 : arg3);
    }

    public static int min(int arg1, int arg2, int arg3, int arg4) {
        return CommonUtils.min(CommonUtils.min(arg1, arg2), CommonUtils.min(arg3, arg4));
    }

    public static Integer min(Integer arg1, Integer arg2, Integer arg3) {
        return CommonUtils.min(CommonUtils.min(arg1, arg2), arg3);
    }

    public static Integer min(Integer arg1, Integer arg2, Integer arg3, Integer arg4) {
        return CommonUtils.min(CommonUtils.min(arg1, arg2), CommonUtils.min(arg3, arg4));
    }

    public static long max(long arg1, long arg2) {
        return arg1 > arg2 ? arg1 : arg2;
    }

    public static Long min(Long arg1, Long arg2) {
        if (arg1 == null) {
            if (arg2 == null) {
                return null;
            }
            return arg2;
        }
        if (arg2 == null) {
            return arg1;
        }
        return CommonUtils.min((long)arg1, (long)arg2);
    }

    public static int max(int arg1, int arg2) {
        return arg1 > arg2 ? arg1 : arg2;
    }

    public static Integer max(Integer arg1, Integer arg2) {
        if (arg1 == null) {
            if (arg2 == null) {
                return null;
            }
            return arg2;
        }
        if (arg2 == null) {
            return arg1;
        }
        return CommonUtils.max((int)arg1, (int)arg2);
    }

    public static Long max(Long arg1, Long arg2) {
        if (arg1 == null) {
            if (arg2 == null) {
                return null;
            }
            return arg2;
        }
        if (arg2 == null) {
            return arg1;
        }
        return CommonUtils.max((long)arg1, (long)arg2);
    }

    public static long max(long arg1, long arg2, long arg3) {
        return arg1 > arg2 ? (arg1 > arg3 ? arg1 : arg3) : (arg2 > arg3 ? arg2 : arg3);
    }

    public static Long max(Long arg1, Long arg2, Long arg3) {
        return CommonUtils.max(CommonUtils.max(arg1, arg2), arg3);
    }

    public static long max(long arg1, long arg2, long arg3, long arg4) {
        return CommonUtils.max(CommonUtils.max(arg1, arg2), CommonUtils.max(arg3, arg4));
    }

    public static Long max(Long arg1, Long arg2, Long arg3, Long arg4) {
        return CommonUtils.max(CommonUtils.max(arg1, arg2), CommonUtils.max(arg3, arg4));
    }

    public static Long notZero(Long ... args) {
        for (Long arg : args) {
            if (arg == null || arg == 0L) continue;
            return arg;
        }
        return null;
    }

    public static Integer notZero(Integer ... args) {
        for (Integer arg : args) {
            if (arg == null || arg == 0) continue;
            return arg;
        }
        return null;
    }

    public static int notZero(int arg1, int arg2) {
        return arg1 == 0 ? arg2 : arg1;
    }

    public static boolean isPositive(Number value) {
        if (value == null) {
            return false;
        }
        return value.longValue() > 0L;
    }

    public static int size(StringBuilder c) {
        if (c == null) {
            return 0;
        }
        return c.length();
    }

    public static int size(String c) {
        if (c == null) {
            return 0;
        }
        return c.length();
    }

    public static int size(Collection<?> c) {
        if (c == null) {
            return 0;
        }
        return c.size();
    }

    public static int size(Map<?, ?> m) {
        if (m == null) {
            return 0;
        }
        return m.size();
    }

    public static int size(Object[] args) {
        if (args == null) {
            return 0;
        }
        return args.length;
    }

    public static int size(byte[] args) {
        if (args == null) {
            return 0;
        }
        return args.length;
    }

    public static boolean eq(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public static boolean eq(Object[] obj1, Object[] obj2) {
        return Arrays.deepEquals(obj1, obj2);
    }

    public static boolean eq(String[] obj1, String[] obj2) {
        return Arrays.deepEquals(obj1, obj2);
    }

    public static boolean eq(boolean[] a, boolean[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean eq(byte[] a, byte[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean eq(char[] a, char[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean eq(short[] a, short[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean eq(int[] a, int[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean eq(long[] a, long[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean eq(float[] a, float[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean eq(double[] a, double[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean eq(long obj1, long obj2) {
        return obj1 == obj2;
    }

    public static boolean eqIgnoreCase(String obj1, String obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equalsIgnoreCase(obj2);
    }

    public static boolean eqColumnName(Column column, Column targetColumn) {
        return CommonUtils.eqIgnoreCase(column.getName(), targetColumn.getName());
    }

    public static boolean eqColumnName(Column column, ReferenceColumn targetColumn) {
        return CommonUtils.eqIgnoreCase(column.getName(), targetColumn.getName());
    }

    public static boolean eqColumnName(ReferenceColumn column, Column targetColumn) {
        return CommonUtils.eqIgnoreCase(column.getName(), targetColumn.getName());
    }

    public static boolean eqColumnName(ReferenceColumn column, ReferenceColumn targetColumn) {
        return CommonUtils.eqIgnoreCase(column.getName(), targetColumn.getName());
    }

    public static boolean eqColumnNames(Column[] columns, Column[] targetColumns) {
        if (columns.length != targetColumns.length) {
            return false;
        }
        int size = columns.length;
        for (int i = 0; i < size; ++i) {
            if (CommonUtils.eqColumnName(columns[i], targetColumns[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean eqColumnNames(Column[] columns, ReferenceColumn[] targetColumns) {
        if (columns.length != targetColumns.length) {
            return false;
        }
        int size = columns.length;
        for (int i = 0; i < size; ++i) {
            if (CommonUtils.eqColumnName(columns[i], targetColumns[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean eqColumnNames(ReferenceColumn[] columns, Column[] targetColumns) {
        if (columns.length != targetColumns.length) {
            return false;
        }
        int size = columns.length;
        for (int i = 0; i < size; ++i) {
            if (CommonUtils.eqColumnName(columns[i], targetColumns[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean eqColumnNames(ReferenceColumn[] columns, ReferenceColumn[] targetColumns) {
        if (columns.length != targetColumns.length) {
            return false;
        }
        int size = columns.length;
        for (int i = 0; i < size; ++i) {
            if (CommonUtils.eqIgnoreCase(columns[i].getName(), targetColumns[i].getName())) continue;
            return false;
        }
        return true;
    }

    public static <T> List<T> cloneList(List<T> list) {
        if (list == null) {
            return null;
        }
        List clone = (List)CommonUtils.cast(CommonUtils.newInstance(list));
        for (T val : list) {
            clone.add(val);
        }
        return clone;
    }

    public static <T> Set<T> cloneSet(Set<T> set) {
        if (set == null) {
            return null;
        }
        Set clone = (Set)CommonUtils.cast(CommonUtils.newInstance(set));
        for (T val : set) {
            clone.add(val);
        }
        return clone;
    }

    public static <S, T> Map<S, T> cloneMap(Map<S, T> map) {
        if (map == null) {
            return null;
        }
        Map clone = (Map)CommonUtils.cast(CommonUtils.newInstance(map));
        for (Map.Entry<S, T> entry : map.entrySet()) {
            clone.put(entry.getKey(), entry.getValue());
        }
        return clone;
    }

    public static boolean isNumberClass(Class<?> clazz) {
        return clazz.isAssignableFrom(Number.class);
    }

    public static int sum(int val1, int val2) {
        return val1 + val2;
    }

    public static int sum(int val1, int val2, int val3) {
        return val1 + val2 + val3;
    }

    public static int sum(int val1, int val2, int val3, int val4) {
        return val1 + val2 + val3 + val4;
    }

    public static int sum(int ... vals) {
        int count = 0;
        int size = vals.length;
        for (int i = 0; i < size; ++i) {
            count += vals[i];
        }
        return count;
    }

    public static boolean containsValue(int[] vals, int containsVal) {
        int size = vals.length;
        for (int i = 0; i < size; ++i) {
            if (containsVal != vals[i]) continue;
            return true;
        }
        return false;
    }

    public static long sum(long ... vals) {
        long count = 0L;
        int size = vals.length;
        for (int i = 0; i < size; ++i) {
            count += vals[i];
        }
        return count;
    }

    public static long sum(long val1, long val2) {
        return val1 + val2;
    }

    public static long sum(long val1, long val2, long val3) {
        return val1 + val2 + val3;
    }

    public static long sum(long val1, long val2, long val3, long val4) {
        return val1 + val2 + val3 + val4;
    }

    public static boolean isBean(Object obj) {
        return obj.getClass().getDeclaringClass() == null;
    }

    public static boolean isBlank(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return CommonUtils.isBlank((CharSequence)obj);
        }
        return CommonUtils.isEmpty(obj);
    }

    public static boolean isBlank(CharSequence obj) {
        if (obj == null || obj.length() == 0) {
            return true;
        }
        int size = obj.length();
        for (int i = 0; i < size; ++i) {
            char c = obj.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence obj) {
        return !CommonUtils.isBlank(obj);
    }

    public static boolean isNotBlank(Object obj) {
        return !CommonUtils.isBlank(obj);
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length() == 0;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size() == 0;
        }
        if (obj instanceof Map) {
            return ((Map)obj).size() == 0;
        }
        if (obj instanceof DbInfo) {
            return ((DbInfo)obj).isEmpty();
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        return false;
    }

    public static boolean isEmpty(CharSequence obj) {
        if (obj == null) {
            return true;
        }
        return obj.length() == 0;
    }

    public static boolean isEmpty(Collection<?> obj) {
        if (obj == null) {
            return true;
        }
        return obj.size() == 0;
    }

    public static boolean isEmpty(Map<?, ?> obj) {
        if (obj == null) {
            return true;
        }
        return obj.size() == 0;
    }

    public static boolean isEmpty(DbInfo obj) {
        if (obj == null) {
            return true;
        }
        return obj.isEmpty();
    }

    public static boolean isNotEmpty(Object obj) {
        return !CommonUtils.isEmpty(obj);
    }

    public static boolean isNotEmpty(CharSequence obj) {
        return !CommonUtils.isEmpty(obj);
    }

    public static boolean isNotEmpty(Collection<?> obj) {
        return !CommonUtils.isEmpty(obj);
    }

    public static boolean isNotEmpty(Map<?, ?> obj) {
        return !CommonUtils.isEmpty(obj);
    }

    public static boolean isNotEmpty(DbInfo obj) {
        return !CommonUtils.isEmpty(obj);
    }

    public static boolean isAllEmpty(Object ... args) {
        for (Object arg : args) {
            if (CommonUtils.isEmpty(arg)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllNullOrEmpty(String ... args) {
        for (String arg : args) {
            if (CommonUtils.isEmpty((Object)arg)) continue;
            return false;
        }
        return true;
    }

    public static String emptyToNull(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }

    public static String notEmpty(String arg1, String arg2) {
        if (!CommonUtils.isEmpty(arg1)) {
            return arg1;
        }
        return arg2;
    }

    public static String notEmpty(String arg1, String arg2, String arg3) {
        if (!CommonUtils.isEmpty(arg1)) {
            return arg1;
        }
        if (!CommonUtils.isEmpty(arg2)) {
            return arg2;
        }
        return arg3;
    }

    public static String notEmpty(String arg1, String arg2, String arg3, String arg4) {
        if (!CommonUtils.isEmpty(arg1)) {
            return arg1;
        }
        if (!CommonUtils.isEmpty(arg2)) {
            return arg2;
        }
        if (!CommonUtils.isEmpty(arg3)) {
            return arg3;
        }
        return arg4;
    }

    public static String notEmpty(String ... args) {
        for (String arg : args) {
            if (CommonUtils.isEmpty(arg)) continue;
            return arg;
        }
        return null;
    }

    public static String trim(String value) {
        if (value == null) {
            return value;
        }
        return value.trim();
    }

    public static String trim(String value, char ... cs) {
        int k;
        boolean exists;
        if (value == null) {
            return value;
        }
        int length = value.length();
        int i = 0;
        int j = 0;
        for (i = 0; i < length; ++i) {
            exists = false;
            for (k = 0; k < cs.length; ++k) {
                if (value.charAt(i) != cs[k]) continue;
                exists = true;
                break;
            }
            if (!exists) break;
        }
        for (j = length - 1; j >= 0; --j) {
            exists = false;
            for (k = 0; k < cs.length; ++k) {
                if (value.charAt(j) != cs[k]) continue;
                exists = true;
                break;
            }
            if (!exists) break;
        }
        if (i > j) {
            return "";
        }
        return value.substring(i, j + 1);
    }

    public static <T> T copy(Object targetObject) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(targetObject);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            Object val = ois.readObject();
            return (T)val;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static int abs(int val) {
        if (val < 0) {
            return -val;
        }
        return val;
    }

    public static long abs(long val) {
        if (val < 0L) {
            return -val;
        }
        return val;
    }

    public static double abs(double val) {
        if (val < 0.0) {
            return -val;
        }
        return val;
    }

    public static BigDecimal abs(BigDecimal val) {
        if (val == null) {
            return null;
        }
        return val.abs();
    }

    public static String left(String value, int len) {
        if (value == null || value.length() == 0) {
            return value;
        }
        if (value.length() < len) {
            return value;
        }
        return value.substring(0, len);
    }

    public static String right(String value, int len) {
        if (value == null || value.length() == 0) {
            return value;
        }
        if (value.length() < len) {
            return value;
        }
        return value.substring(value.length() - len, value.length());
    }

    public static String rtrim(String value, char ... deleteChars) {
        if (value == null || value.length() == 0) {
            return value;
        }
        if (deleteChars == null || deleteChars.length == 0) {
            return value;
        }
        int i = 0;
        for (i = value.length() - 1; i >= 0; --i) {
            boolean find = false;
            for (char deleteChar : deleteChars) {
                if (value.charAt(i) != deleteChar) continue;
                find = true;
                break;
            }
            if (!find) break;
        }
        return value.substring(0, i + 1);
    }

    public static String rtrim(String value) {
        return CommonUtils.rtrim(value, ' ', '\n', '\r', '\t');
    }

    public static String ltrim(String value, char deleteChar) {
        if (value == null || value.length() == 0) {
            return value;
        }
        int i = 0;
        for (i = 0; i < value.length() && value.charAt(i) == deleteChar; ++i) {
        }
        return value.substring(i);
    }

    public static String ltrim(String value) {
        return CommonUtils.ltrim(value, ' ');
    }

    public static Long toLong(String val) {
        if (CommonUtils.isEmpty(val)) {
            return null;
        }
        try {
            Long size = Long.valueOf(val);
            return size;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Integer toInteger(String val) {
        if (CommonUtils.isEmpty(val)) {
            return null;
        }
        try {
            Integer size = Integer.valueOf(val);
            return size;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static long[] toLongArray(Long[] vals) {
        int size = vals.length;
        long[] ret = new long[vals.length];
        for (int i = 0; i < size; ++i) {
            if (vals[i] == null) continue;
            ret[i] = vals[i];
        }
        return ret;
    }

    public static int[] toIntArray(Integer[] vals) {
        int size = vals.length;
        int[] ret = new int[vals.length];
        for (int i = 0; i < size; ++i) {
            if (vals[i] == null) continue;
            ret[i] = vals[i];
        }
        return ret;
    }

    public static short[] toShortArray(Short[] vals) {
        int size = vals.length;
        short[] ret = new short[vals.length];
        for (int i = 0; i < size; ++i) {
            if (vals[i] == null) continue;
            ret[i] = vals[i];
        }
        return ret;
    }

    public static byte[] toByteArray(Byte[] vals) {
        int size = vals.length;
        byte[] ret = new byte[vals.length];
        for (int i = 0; i < size; ++i) {
            if (vals[i] == null) continue;
            ret[i] = vals[i];
        }
        return ret;
    }

    public static float[] toFloatArray(Float[] vals) {
        int size = vals.length;
        float[] ret = new float[vals.length];
        for (int i = 0; i < size; ++i) {
            if (vals[i] == null) continue;
            ret[i] = vals[i].floatValue();
        }
        return ret;
    }

    public static double[] toDoubleArray(Double[] vals) {
        int size = vals.length;
        double[] ret = new double[vals.length];
        for (int i = 0; i < size; ++i) {
            if (vals[i] == null) continue;
            ret[i] = vals[i];
        }
        return ret;
    }

    public static String deleteLineSeparator(String val) {
        if (CommonUtils.isEmpty(val)) {
            return val;
        }
        return val.replace("\r", "").replace("\n", "");
    }

    public static String replaceInvalidCharacter(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(text.length());
        int len = text.codePointCount(0, text.length());
        for (int i = 0; i < len; ++i) {
            int codePoint = text.codePointAt(i);
            if (codePoint == 10) {
                builder.appendCodePoint(codePoint);
                continue;
            }
            if (codePoint == 9) {
                builder.appendCodePoint(codePoint);
                continue;
            }
            if (Character.isISOControl(codePoint)) continue;
            builder.appendCodePoint(codePoint);
        }
        return builder.toString();
    }

    public static String[] split(String value, String regex) {
        if (CommonUtils.isEmpty(value)) {
            return new String[0];
        }
        return value.split(regex);
    }

    public static List<String> splitLine(String value) {
        String[] split;
        if (CommonUtils.isEmpty(value)) {
            return CommonUtils.list();
        }
        List<String> result = CommonUtils.list();
        for (String val : split = value.split("\n")) {
            result.add(CommonUtils.replaceInvalidCharacter(val));
        }
        return result;
    }

    public static BigDecimal setScale(BigDecimal val, int newScale) {
        if (val == null) {
            return null;
        }
        return val.setScale(newScale);
    }

    public static int xor(int arg1, int arg2) {
        return arg1 ^ arg2;
    }

    public static int xor(int arg1, int arg2, int arg3) {
        return arg1 ^ arg2 ^ arg3;
    }

    public static int xor(int arg1, int arg2, int arg3, int arg4) {
        return arg1 ^ arg2 ^ arg3 ^ arg4;
    }

    public static int xor(int ... args) {
        if (args == null || args.length == 0) {
            return 0;
        }
        int val = args[0];
        int len = args.length;
        for (int i = 1; i < len; ++i) {
            val ^= args[i];
        }
        return val;
    }

    public static int hashCode(Object arg) {
        return arg == null ? 0 : arg.hashCode();
    }

    public static int hashCode(Object arg1, Object arg2) {
        return CommonUtils.hashCode(arg1) ^ CommonUtils.hashCode(arg2);
    }

    public static int hashCode(Object arg1, Object arg2, Object arg3) {
        return CommonUtils.hashCode(arg1) ^ CommonUtils.hashCode(arg2) ^ CommonUtils.hashCode(arg3);
    }

    public static int hashCode(Object arg1, Object arg2, Object arg3, Object arg4) {
        return CommonUtils.hashCode(arg1) ^ CommonUtils.hashCode(arg2) ^ CommonUtils.hashCode(arg3) ^ CommonUtils.hashCode(arg4);
    }

    public static int hashCode(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return CommonUtils.hashCode(arg1) ^ CommonUtils.hashCode(arg2) ^ CommonUtils.hashCode(arg3) ^ CommonUtils.hashCode(arg4) ^ CommonUtils.hashCode(arg5);
    }

    public static int hashCode(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        return CommonUtils.hashCode(arg1) ^ CommonUtils.hashCode(arg2) ^ CommonUtils.hashCode(arg3) ^ CommonUtils.hashCode(arg4) ^ CommonUtils.hashCode(arg5) ^ CommonUtils.hashCode(arg6);
    }

    public static int xor(Object ... args) {
        if (args == null || args.length == 0) {
            return 0;
        }
        int val = 0;
        if (args[0] != null) {
            val = args[0].hashCode();
        }
        int len = args.length;
        for (int i = 1; i < len; ++i) {
            if (args[i] == null) continue;
            val ^= CommonUtils.hashCode(args[i]);
        }
        return val;
    }

    public static int xor(boolean caseInsensitive, String arg) {
        if (arg == null) {
            return 0;
        }
        int val = 0;
        val = caseInsensitive ? arg.toUpperCase().hashCode() : arg.hashCode();
        return val;
    }

    public static int xor(boolean caseInsensitive, String ... args) {
        if (args == null || args.length == 0) {
            return 0;
        }
        int val = CommonUtils.xor(caseInsensitive, args[0]);
        int len = args.length;
        for (int i = 1; i < len; ++i) {
            val ^= CommonUtils.xor(caseInsensitive, args[i]);
        }
        return val;
    }

    public static Throwable getRootCause(Throwable t) {
        if (t.getCause() == null || t == t.getCause()) {
            return t;
        }
        return CommonUtils.getRootCause(t.getCause());
    }

    public static String unwrap(String val, String prefix, String suffix) {
        if (CommonUtils.isEmpty(val)) {
            return val;
        }
        if (val.startsWith(prefix) && val.endsWith(suffix)) {
            String newVal = val.substring(prefix.length(), val.length() - suffix.length());
            if (newVal.startsWith(prefix)) {
                return CommonUtils.unwrap(newVal, prefix, suffix);
            }
            return newVal;
        }
        return val;
    }

    public static String unwrap(String val, char prefix, char suffix) {
        if (CommonUtils.isEmpty(val)) {
            return val;
        }
        if (val.charAt(0) == prefix && val.charAt(val.length() - 1) == suffix) {
            String newVal = val.substring(1, val.length() - 1);
            if (newVal.length() == 0) {
                return newVal;
            }
            if (newVal.charAt(0) == prefix) {
                return CommonUtils.unwrap(newVal, prefix, suffix);
            }
            return newVal;
        }
        return val;
    }

    public static String unwrap(String val, String quate) {
        if (CommonUtils.isEmpty(val)) {
            return val;
        }
        if (val.startsWith(quate) && val.endsWith(quate)) {
            String newVal = val.substring(quate.length(), val.length() - quate.length());
            if (newVal.startsWith(quate)) {
                return CommonUtils.unwrap(newVal, quate);
            }
            return newVal;
        }
        return val;
    }

    public static String unwrap(String val, char quate) {
        if (CommonUtils.isEmpty(val)) {
            return val;
        }
        if (val.charAt(0) == quate && val.charAt(val.length() - 1) == quate) {
            String newVal = val.substring(1, val.length() - 1);
            if (newVal.length() == 0) {
                return newVal;
            }
            if (newVal.charAt(0) == quate) {
                return CommonUtils.unwrap(newVal, quate);
            }
            return newVal;
        }
        return val;
    }

    public static String replace(String val, String target, String replacement) {
        if (CommonUtils.isEmpty(val)) {
            return val;
        }
        return val.replace(target, replacement);
    }

    public static String replaceAll(String val, String target, String replacement) {
        if (CommonUtils.isEmpty(val)) {
            return val;
        }
        return val.replaceAll(target, replacement);
    }

    public static String toString(Collection<?> c) {
        StringBuilder builder = new StringBuilder("{");
        boolean first = true;
        for (Object obj : c) {
            if (!first) {
                builder.append(", ");
            }
            builder.append(obj);
            first = false;
        }
        builder.append("}");
        return builder.toString();
    }

    public static int compare(int a, int b) {
        return a - b;
    }

    public static int compare(boolean a, boolean b) {
        if (a == b) {
            return 0;
        }
        if (a) {
            return 1;
        }
        return -1;
    }

    public static int compare(Comparable a, Object b) {
        if (a == null) {
            if (b == null) {
                return 0;
            }
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    public static int compare(Object a, Object b) {
        if (a == null) {
            if (b == null) {
                return 0;
            }
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof Comparable) {
            return CommonUtils.compare((Comparable)a, b);
        }
        return CommonUtils.compare((Comparable)((Object)a.toString()), b);
    }

    public static char[] getChars(char c, int size) {
        char[] result = new char[size];
        for (int i = 0; i < size; ++i) {
            result[i] = c;
        }
        return result;
    }

    public static String getString(char c, int size) {
        StringBuilder builder = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            builder.append(c);
        }
        return builder.toString();
    }

    public static String getString(String val, int size) {
        StringBuilder builder = new StringBuilder(val.length() * size);
        for (int i = 0; i < size; ++i) {
            builder.append(val);
        }
        return builder.toString();
    }

    public static Timestamp newTimestamp() {
        Timestamp ts = new Timestamp(new Date().getTime());
        return ts;
    }

    public static Pattern getPattern(String regex) {
        Pattern pattern = (Pattern)compiledPatternMap.get(regex);
        if (pattern != null) {
            return pattern;
        }
        pattern = Pattern.compile(regex);
        Pattern oldPattern = compiledPatternMap.putIfAbsent(regex, pattern);
        return oldPattern == null ? pattern : oldPattern;
    }

    public static Pattern getPattern(String regex, int option) {
        Pattern oldPattern;
        Integer intOp;
        Pattern pattern;
        ConcurrentMap oldMap;
        ConcurrentMap map = (ConcurrentMap)compiledOptionPatternMap.get(regex);
        if (map == null && (oldMap = compiledOptionPatternMap.putIfAbsent(regex, map = CommonUtils.concurrentMap())) != null) {
            map = oldMap;
        }
        if ((pattern = (Pattern)map.get(intOp = Integer.valueOf(option))) == null && (oldPattern = map.putIfAbsent(intOp, pattern = Pattern.compile(regex, option))) != null) {
            pattern = oldPattern;
        }
        return pattern;
    }

    public static RuntimeException toRe(Exception e) {
        return new RuntimeException(e);
    }

    public static Class<?> getWrapperClass(Class<?> clazz) {
        return PRIMITIVE_WRAPPER_CLASS_MAP.get(clazz);
    }

    public static String toUpperCase(String val) {
        if (val == null) {
            return val;
        }
        return val.toUpperCase();
    }

    public static String toLowerCase(String val) {
        if (val == null) {
            return val;
        }
        return val.toLowerCase();
    }

    public static Map<String, String> parseKeyValue(String ... texts) {
        return CommonUtils.parseKeyValue(";", "=", texts);
    }

    public static Map<String, String> parseKeyValue(String separator, String keyValueSeparator, String ... texts) {
        if (CommonUtils.isEmpty(texts)) {
            return CommonUtils.linkedMap(0);
        }
        Map<String, String> result = CommonUtils.linkedMap();
        for (String text : texts) {
            String[] splits;
            for (String sp : splits = CommonUtils.trim(text).split(separator)) {
                String[] keyValue = CommonUtils.trim(sp).split(keyValueSeparator);
                if (keyValue.length <= 1) continue;
                result.put(CommonUtils.trim(keyValue[0]), CommonUtils.trim(keyValue[1]));
            }
        }
        return result;
    }

    public static String reverse(String value) {
        if (value == null || value.length() <= 1) {
            return value;
        }
        StringBuilder builder = new StringBuilder(value.length());
        for (int i = value.length() - 1; i >= 0; --i) {
            builder.append(value.charAt(i));
        }
        return builder.toString();
    }

    public static byte[] clone(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        byte[] cloneBytes = new byte[bytes.length];
        System.arraycopy(bytes, 0, cloneBytes, 0, bytes.length);
        return cloneBytes;
    }

    public static String initCap(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return value.substring(0, 1).toUpperCase() + value.substring(1);
    }

    public static Locale getLocale(String text) {
        if (CommonUtils.isEmpty(text)) {
            return null;
        }
        Locale result = LOCALE_CACHE.get(text);
        if (result != null) {
            return result;
        }
        return null;
    }

    public static final void clear() {
        DateUtils.clear();
    }

    public static boolean isAssignableFrom(Class<?> clazz1, Class<?> clazz2) {
        Boolean val;
        Map<Class<Object>, Boolean> map = ASSIGNABLE_FROM_CACHE.get(clazz1);
        if (map == null) {
            map = CommonUtils.map();
            ASSIGNABLE_FROM_CACHE.put(clazz1, map);
        }
        if ((val = map.get(clazz2)) != null) {
            return val;
        }
        boolean ret = clazz1.isAssignableFrom(clazz2);
        map.put(clazz2, ret);
        return ret;
    }

    public static <T> List<T> emptyList() {
        return Collections.EMPTY_LIST;
    }

    public static <T> Set<T> emptySet() {
        return Collections.EMPTY_SET;
    }

    public static <S, T> Map<S, T> emptyMap() {
        return Collections.EMPTY_MAP;
    }

    private static int pow(int val, int n) {
        return (int)Math.pow(val, n);
    }

    private static long pow(long val, int n) {
        return (long)Math.pow(val, n);
    }

    @SafeVarargs
    public static <T> Set<T> and(Set<T> ... sets) {
        if (CommonUtils.isEmpty(sets)) {
            return CommonUtils.set();
        }
        Set<T> firstSet = CommonUtils.first(sets);
        Set<T> result = CommonUtils.set(firstSet);
        for (T obj : firstSet) {
            for (int i = 1; i < sets.length; ++i) {
                Set<T> set = sets[1];
                if (set.contains(obj)) continue;
                result.remove(obj);
            }
        }
        return result;
    }

    public static <T> Set<T> and(Set<T> set1, Set<T> set2) {
        if (CommonUtils.isEmpty(set1) || CommonUtils.isEmpty(set2)) {
            return CommonUtils.set();
        }
        Set<T> result = CommonUtils.set(set1);
        for (T obj : set1) {
            if (set2.contains(obj)) continue;
            result.remove(obj);
        }
        return result;
    }

    public static <T> T[] toArray(Object args, Class<T[]> clazz) {
        if (args == null) {
            return null;
        }
        if (args.getClass() == clazz) {
            return (Object[])args;
        }
        int length = Array.getLength(args);
        Object[] ret = (Object[])Array.newInstance(clazz.getComponentType(), length);
        System.arraycopy(args, 0, ret, 0, length);
        return ret;
    }

    public static String substring(String text, int beginIndex, int endIndex) {
        if (text == null) {
            return null;
        }
        int startPos = beginIndex;
        int endPos = endIndex;
        if (beginIndex >= endIndex) {
            return null;
        }
        if (text.length() <= endIndex) {
            endPos = text.length();
        }
        return text.substring(startPos, endPos);
    }

    public static Class<?> getPrimitiveClass(Class<?> clazz) {
        return PRIMITIVE_WRAPPER_CLASS_MAP.get(clazz);
    }

    static {
        Locale[] locales;
        LEN_1KB = CommonUtils.pow(2, 10);
        LEN_64KB = CommonUtils.pow(2, 16);
        LEN_1MB = CommonUtils.pow(2, 20);
        LEN_16MB = CommonUtils.pow(2, 24);
        LEN_1GB = CommonUtils.pow(2, 30);
        LEN_2GB = CommonUtils.pow(2, 31);
        LEN_4GB = CommonUtils.pow(2L, 32);
        PRIMITIVE_WRAPPER_CLASS_MAP = CommonUtils.map(16);
        ENV_MAP = null;
        CommonUtils.setPrimitiveWrapperMapping(Boolean.TYPE, Boolean.class);
        CommonUtils.setPrimitiveWrapperMapping(Byte.TYPE, Byte.class);
        CommonUtils.setPrimitiveWrapperMapping(Short.TYPE, Short.class);
        CommonUtils.setPrimitiveWrapperMapping(Integer.TYPE, Integer.class);
        CommonUtils.setPrimitiveWrapperMapping(Long.TYPE, Long.class);
        CommonUtils.setPrimitiveWrapperMapping(Float.TYPE, Float.class);
        CommonUtils.setPrimitiveWrapperMapping(Double.TYPE, Double.class);
        CommonUtils.setPrimitiveWrapperMapping(Character.TYPE, Character.class);
        CommonUtils.setPrimitiveWrapperMapping(boolean[].class, Boolean[].class);
        CommonUtils.setPrimitiveWrapperMapping(byte[].class, Byte[].class);
        CommonUtils.setPrimitiveWrapperMapping(short[].class, Short[].class);
        CommonUtils.setPrimitiveWrapperMapping(int[].class, Integer[].class);
        CommonUtils.setPrimitiveWrapperMapping(long[].class, Long[].class);
        CommonUtils.setPrimitiveWrapperMapping(float[].class, Float[].class);
        CommonUtils.setPrimitiveWrapperMapping(double[].class, Double[].class);
        CommonUtils.setPrimitiveWrapperMapping(char[].class, Character[].class);
        CommonUtils.initializeEnv();
        classCache = new ConcurrentHashMap();
        compiledPatternMap = CommonUtils.concurrentMap();
        compiledOptionPatternMap = CommonUtils.concurrentMap();
        LOCALE_CACHE = CommonUtils.upperMap();
        for (Locale locale : locales = Locale.getAvailableLocales()) {
            LOCALE_CACHE.put(locale.toString(), locale);
            LOCALE_CACHE.put(locale.toLanguageTag(), locale);
        }
        for (Locale locale : locales) {
            if (LOCALE_CACHE.containsKey(locale.getLanguage())) continue;
            LOCALE_CACHE.put(locale.getLanguage(), locale);
        }
        for (Locale locale : locales) {
            if ("no".equals(locale.toLanguageTag())) {
                LOCALE_CACHE.put("nb", locale);
            }
            if (!"no-NO".equals(locale.toLanguageTag())) continue;
            LOCALE_CACHE.put("nb-NO", locale);
        }
        ASSIGNABLE_FROM_CACHE = CommonUtils.map();
    }
}

