/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SeparatedStringBuilder;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class DiffStringBuilder
implements Serializable {
    private static final long serialVersionUID = -2873994302982754793L;
    private String className = null;
    private SeparatedStringBuilder builder = new SeparatedStringBuilder(", ");
    private boolean exceptEmpty = true;
    private Converters converters = Converters.getNewBooleanTrueInstance();

    public DiffStringBuilder(String className) {
        this.className = className;
    }

    public DiffStringBuilder(Class<?> clazz) {
        this.className = clazz.getSimpleName();
    }

    public DiffStringBuilder setDiff(String propertyName, Object value1, Object value2) {
        if (this.exceptEmpty && CommonUtils.isEmpty(value1)) {
            return this;
        }
        if (CommonUtils.eq(value1, value2)) {
            return this;
        }
        if (value1 instanceof Collection && value2 instanceof Collection) {
            return this.setDiff(propertyName, (Collection)value1, (Collection)value2);
        }
        this.addElement(propertyName, value1);
        return this;
    }

    public DiffStringBuilder setDiff(String propertyName, Map<?, ?> map1, Map<?, ?> map2) {
        if (this.exceptEmpty && CommonUtils.isEmpty(map1)) {
            return this;
        }
        if (CommonUtils.eq(map1, map2)) {
            return this;
        }
        if (CommonUtils.isEmpty(map2)) {
            this.addElement(propertyName, map1);
            return this;
        }
        Set keys = CommonUtils.treeSet();
        keys.addAll(map1.keySet());
        keys.addAll(map2.keySet());
        DiffStringBuilder builder = new DiffStringBuilder(propertyName);
        for (Object prop : keys) {
            Object value1 = map1.get(prop);
            Object value2 = map2.get(prop);
            builder.setDiff(prop.toString(), value1, value2);
        }
        this.add(builder);
        return this;
    }

    public DiffStringBuilder setDiffIgnoreCase(String propertyName, String value1, String value2) {
        if (this.exceptEmpty && CommonUtils.isEmpty(value1)) {
            return this;
        }
        if (CommonUtils.eqIgnoreCase(value1, value2)) {
            return this;
        }
        this.addElement(propertyName, value1);
        return this;
    }

    public DiffStringBuilder setDiff(String propertyName, Collection<?> value1, Collection<?> value2) {
        if (this.exceptEmpty && CommonUtils.isEmpty(value1)) {
            return this;
        }
        if (CommonUtils.eq(value1, value2)) {
            return this;
        }
        SeparatedStringBuilder sep = new SeparatedStringBuilder("\n");
        sep.setStart("(").setEnd(")");
        sep.add(value1);
        this.addElement("\n" + propertyName, sep.toString());
        return this;
    }

    public DiffStringBuilder setDiff(Object value) {
        this.builder.add(value);
        return this;
    }

    public DiffStringBuilder setDiff(DiffStringBuilder value) {
        if (!value.isEmpty()) {
            this.builder.add((Object)value);
        }
        return this;
    }

    public DiffStringBuilder addElement(String propertyName, Object value) {
        if (value == null) {
            return this;
        }
        if (this.converters.isConvertable(value.getClass())) {
            this.addElement(propertyName, this.converters.convertString(value));
        } else {
            this.addElement(propertyName, value.toString());
        }
        return this;
    }

    private void addElement(String propertyName, String value) {
        this.builder.add((Object)(propertyName + "=" + value));
    }

    public DiffStringBuilder add(DiffStringBuilder diffStringBuilder) {
        this.builder.add(diffStringBuilder.builder.getElements());
        return this;
    }

    public String toString() {
        String val = this.builder.toString();
        StringBuilder result = new StringBuilder(this.className.length() + val.length() + 2);
        result.append(this.className).append('[').append(val).append(']');
        return result.toString();
    }

    public boolean isEmpty() {
        return this.builder.size() == 0;
    }
}

