/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.Table;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Objects;

public class FontUtils {
    public static Font[] getFonts() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return graphicsEnvironment.getAllFonts();
    }

    public static boolean isValidFontName(String fontname) {
        for (Font font : FontUtils.getFonts()) {
            if (!Objects.equals(font.getName(), fontname)) continue;
            return true;
        }
        return false;
    }

    public static Table getFontsAsTable() {
        Table table = new Table();
        Column column = table.newColumn();
        column.setName("name");
        table.getColumns().add(column);
        column = table.newColumn();
        column.setName("family");
        table.getColumns().add(column);
        for (Font font : FontUtils.getFonts()) {
            Row row = table.newRow();
            row.put("name", (Object)font.getFontName());
            row.put("family", (Object)font.getFamily());
            table.getRows().add(row);
        }
        return table;
    }

    public static Table getFontNamesAsTable() {
        Table table = new Table();
        Column column = table.newColumn();
        column.setName("name");
        table.getColumns().add(column);
        table.getColumns().add(column);
        for (Font font : FontUtils.getFonts()) {
            Row row = table.newRow();
            row.put("name", (Object)font.getFontName());
            table.getRows().add(row);
        }
        return table;
    }
}

