/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.AbstractClassSearcher;
import com.sqlapp.util.AbstractJarHandler;
import java.net.URL;
import java.util.List;
import java.util.jar.JarEntry;

public class JarClassSearcher
extends AbstractClassSearcher {
    private static final String[] PROTOCOLS = new String[]{"jar", "zip", "vfszip"};

    @Override
    public <T> List<Class<?>> search(String rootPackageName, URL url, boolean recursive) {
        AbstractJarHandler jarHandler = new AbstractJarHandler<Class<?>, Class<?>>(this.getClassLoader(), this.getFilter()){

            @Override
            protected void handleJarEntry(JarEntry jarEntry, String packageNameAsResourceName, boolean recursive, List<Class<?>> resources) throws ClassNotFoundException {
                if (recursive) {
                    if (jarEntry.getName().startsWith(packageNameAsResourceName) && JarClassSearcher.this.isClassFile(jarEntry.getName())) {
                        try {
                            Class<?> clazz = this.getClassLoader().loadClass(JarClassSearcher.this.resourceNameToClassName(jarEntry.getName()));
                            if (this.getFilter().test(clazz)) {
                                resources.add(clazz);
                            }
                        }
                        catch (Exception e) {
                            JarClassSearcher.this.getExceptionHandler().accept(e);
                        }
                        catch (ClassFormatError e) {
                            JarClassSearcher.this.getExceptionHandler().accept(e);
                        }
                    }
                } else if (this.equalsPackage(jarEntry, packageNameAsResourceName) && JarClassSearcher.this.isClassFile(jarEntry.getName())) {
                    try {
                        Class<?> clazz = this.getClassLoader().loadClass(JarClassSearcher.this.resourceNameToClassName(jarEntry.getName()));
                        if (this.getFilter().test(clazz)) {
                            resources.add(clazz);
                        }
                    }
                    catch (Exception e) {
                        JarClassSearcher.this.getExceptionHandler().accept(e);
                    }
                    catch (ClassFormatError e) {
                        JarClassSearcher.this.getExceptionHandler().accept(e);
                    }
                }
            }
        };
        return jarHandler.search(rootPackageName, url, recursive);
    }

    @Override
    public String[] supportProtocols() {
        return PROTOCOLS;
    }

    private String resourceNameToClassName(String resourceName) {
        return this.fileNameToClassName(resourceName).replace('/', '.');
    }
}

