/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.CommonUtils;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.function.BiConsumer;

public class LinkedProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private Set<Object> keys = CommonUtils.linkedSet();

    @Override
    public synchronized Enumeration<Object> keys() {
        Vector<Object> keyList = new Vector<Object>();
        for (Object key : this.keys) {
            keyList.add(key);
        }
        return keyList.elements();
    }

    @Override
    public synchronized Collection<Object> values() {
        List<Object> result = CommonUtils.list();
        for (Object key : this.keys) {
            result.add(this.get(key));
        }
        return result;
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        Enumeration<Object> keysEnum = this.keys();
        while (keysEnum.hasMoreElements()) {
            Object key = keysEnum.nextElement();
            map.put(key, this.get(key));
        }
        return map.entrySet();
    }

    @Override
    public Set<Object> keySet() {
        return CommonUtils.linkedSet(this.keys);
    }

    @Override
    public synchronized Enumeration<Object> elements() {
        Vector<Object> list = new Vector<Object>();
        for (Object key : this.keys) {
            list.add(this.get(key));
        }
        return list.elements();
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        this.keys.add(key);
        return super.put(key, value);
    }

    @Override
    public Enumeration<?> propertyNames() {
        return this.keys();
    }

    @Override
    public Set<String> stringPropertyNames() {
        Set<String> result = CommonUtils.linkedSet();
        for (Object key : this.keys) {
            result.add(key.toString());
        }
        return result;
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        this.keys.add(key);
        return super.put(key, value);
    }

    @Override
    public synchronized Object remove(Object key) {
        this.keys.remove(key);
        return super.remove(key);
    }

    @Override
    public synchronized Object putIfAbsent(Object key, Object value) {
        this.keys.remove(key);
        return super.putIfAbsent(key, value);
    }

    @Override
    public void list(PrintStream out) {
        out.println("-- listing properties --");
        for (Object key : this.keys) {
            Object obj = this.get(key);
            Object val = obj.toString();
            if (((String)val).length() > 40) {
                val = ((String)val).substring(0, 37) + "...";
            }
            out.println(key + "=" + (String)val);
        }
    }

    @Override
    public void list(PrintWriter out) {
        out.println("-- listing properties --");
        for (Object key : this.keys) {
            Object obj = this.get(key);
            Object val = obj.toString();
            if (((String)val).length() > 40) {
                val = ((String)val).substring(0, 37) + "...";
            }
            out.println(key + "=" + (String)val);
        }
    }

    @Override
    public synchronized void forEach(BiConsumer<Object, Object> action) {
        Objects.requireNonNull(action);
        Set<Map.Entry<Object, Object>> entries = this.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            if (entry == null) continue;
            action.accept(entry.getKey(), entry.getValue());
        }
    }
}

