/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.jdbc.sql.BindParameter;
import com.sqlapp.jdbc.sql.ParameterDirection;
import com.sqlapp.jdbc.sql.SqlParameterCollection;
import com.sqlapp.jdbc.sql.node.Node;
import com.sqlapp.util.DbUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.List;

public class StatementUtils {
    private StatementUtils() {
    }

    public static ResultSet executeQuery(PreparedStatement statement) {
        try {
            return statement.executeQuery();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public int executeUpdate(PreparedStatement statement) {
        try {
            return statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean hasRecord(PreparedStatement statement) throws SQLException {
        ResultSet resultSet = null;
        try {
            resultSet = StatementUtils.executeQuery(statement);
            statement.setFetchSize(1);
            boolean bl = resultSet.next();
            return bl;
        }
        finally {
            DbUtils.close(resultSet);
        }
    }

    public static Object getSingleObject(PreparedStatement statement) throws SQLException {
        ResultSet resultSet = null;
        try {
            resultSet = StatementUtils.executeQuery(statement);
            statement.setFetchSize(1);
            if (resultSet.next()) {
                Object object = resultSet.getObject(1);
                return object;
            }
            Object var2_3 = null;
            return var2_3;
        }
        finally {
            DbUtils.close(resultSet);
        }
    }

    public static Object getSingleObject(CallableStatement statement) throws SQLException {
        ResultSet resultSet = null;
        try {
            resultSet = StatementUtils.executeQuery(statement);
            statement.setFetchSize(1);
            if (resultSet.next()) {
                Object object = resultSet.getObject(1);
                return object;
            }
            Object var2_3 = null;
            return var2_3;
        }
        finally {
            DbUtils.close(resultSet);
        }
    }

    public static PreparedStatement createPreparedStatementReadonly(Connection connection, Node node, ParametersContext parametersContext) throws SQLException {
        SqlParameterCollection sqlParameters = node.eval(parametersContext);
        PreparedStatement statement = connection.prepareStatement(sqlParameters.getSql(), 1003, 1007);
        return statement;
    }

    public static PreparedStatement createPreparedStatement(Connection connection, Node node, ParametersContext parametersContext) {
        PreparedStatement statement;
        SqlParameterCollection sqlParameters = node.eval(parametersContext);
        try {
            statement = connection.prepareStatement(sqlParameters.getSql());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return statement;
    }

    public static CallableStatement createCallableStatementReadonly(Connection connection, Node node, ParametersContext parametersContext) {
        CallableStatement statement;
        SqlParameterCollection sqlParameters = node.eval(parametersContext);
        try {
            statement = connection.prepareCall(sqlParameters.getSql(), 1003, 1007);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CallableStatement createCallableStatement(Connection connection, Node node, ParametersContext parametersContext) throws SQLException {
        SqlParameterCollection sqlParameters = node.eval(parametersContext);
        CallableStatement statement = null;
        try {
            statement = connection.prepareCall(sqlParameters.getSql());
        }
        catch (Throwable throwable) {
            DbUtils.close(statement);
            throw throwable;
        }
        DbUtils.close(statement);
        return statement;
    }

    public static void setParameterToStatement(PreparedStatement statement, SqlParameterCollection sqlParameters) throws SQLException {
        StatementUtils.setParameterToStatement(statement, sqlParameters.getBindParameters());
    }

    public static void setParameterToStatement(CallableStatement statement, SqlParameterCollection sqlParameters) throws SQLException {
        StatementUtils.setParameterToStatement(statement, sqlParameters.getBindParameters());
    }

    public static void setParameterToStatement(PreparedStatement statement, List<BindParameter> bindParameters) throws SQLException {
        for (int i = 0; i < bindParameters.size(); ++i) {
            BindParameter paramter = bindParameters.get(i);
            Object val = paramter.getValue();
            DataType type = paramter.getType();
            statement.setObject(i + 1, val, type.getJdbcType());
        }
    }

    public static void setParameterToStatement(CallableStatement statement, List<BindParameter> bindParameters) throws SQLException {
        for (int i = 0; i < bindParameters.size(); ++i) {
            BindParameter paramter = bindParameters.get(i);
            Object val = paramter.getValue();
            DataType type = paramter.getType();
            if (ParameterDirection.Output.equals((Object)paramter.getDirection())) {
                statement.registerOutParameter(i + 1, (SQLType)type.getJdbcType());
                continue;
            }
            statement.setObject(i + 1, val, (SQLType)type.getJdbcType());
        }
    }
}

