/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.file;

import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.FileUtils;
import com.sqlapp.util.file.AbstractFixedByteLength;
import com.sqlapp.util.file.FixedByteLengthFileSetting;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class FixedByteLengthParser
extends AbstractFixedByteLength
implements AutoCloseable {
    private final BufferedInputStream bis;

    public FixedByteLengthParser(File file, Charset charset, Consumer<FixedByteLengthFileSetting> cons) {
        super(new FixedByteLengthFileSetting(), charset, cons);
        this.bis = FixedByteLengthParser.toBufferedInputStream(file);
    }

    public FixedByteLengthParser(File file, Charset charset, Table table, Consumer<FixedByteLengthFileSetting> cons, Consumer<FixedByteLengthFileSetting.FixedByteLengthFieldSetting> fieldCons) {
        super(new FixedByteLengthFileSetting(), charset, table, cons, fieldCons);
        this.bis = FixedByteLengthParser.toBufferedInputStream(file);
    }

    public FixedByteLengthParser(File file, Charset charset, Table table, Consumer<FixedByteLengthFileSetting> cons) {
        super(new FixedByteLengthFileSetting(), charset, table, cons);
        this.bis = FixedByteLengthParser.toBufferedInputStream(file);
    }

    public FixedByteLengthParser(File file, String charset) {
        super(new FixedByteLengthFileSetting(), Charset.forName(charset), (FixedByteLengthFileSetting setting) -> {});
        this.bis = FixedByteLengthParser.toBufferedInputStream(file);
    }

    public FixedByteLengthParser(InputStream is, Charset charset, Consumer<FixedByteLengthFileSetting> cons) {
        super(new FixedByteLengthFileSetting(), charset, cons);
        this.bis = FixedByteLengthParser.toBufferedInputStream(is);
    }

    public FixedByteLengthParser(InputStream is, Charset charset, Table table, Consumer<FixedByteLengthFileSetting> cons, Consumer<FixedByteLengthFileSetting.FixedByteLengthFieldSetting> fieldCons) {
        super(new FixedByteLengthFileSetting(), charset, table, cons, fieldCons);
        this.bis = FixedByteLengthParser.toBufferedInputStream(is);
    }

    public FixedByteLengthParser(InputStream is, Charset charset, Table table, Consumer<FixedByteLengthFileSetting> cons) {
        super(new FixedByteLengthFileSetting(), charset, table, cons);
        this.bis = FixedByteLengthParser.toBufferedInputStream(is);
    }

    public FixedByteLengthParser(InputStream is, Charset charset) {
        super(new FixedByteLengthFileSetting(), charset, (FixedByteLengthFileSetting setting) -> {});
        this.bis = FixedByteLengthParser.toBufferedInputStream(is);
    }

    public FixedByteLengthParser(InputStream is, String charset) {
        super(new FixedByteLengthFileSetting(), Charset.forName(charset), (FixedByteLengthFileSetting setting) -> {});
        this.bis = FixedByteLengthParser.toBufferedInputStream(is);
    }

    private static BufferedInputStream toBufferedInputStream(File file) {
        try {
            return new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static BufferedInputStream toBufferedInputStream(InputStream is) {
        if (is instanceof BufferedInputStream) {
            return (BufferedInputStream)is;
        }
        return new BufferedInputStream(is);
    }

    public void readAll(BiConsumer<byte[], Long> cons) throws IOException {
        int len;
        long i = 0L;
        FixedByteLengthFileSetting setting = this.getCharsetSetting().clone();
        byte[] buffer = setting.createBuffer();
        while ((len = this.bis.read(buffer)) > 0) {
            if (!setting.isLineBreak(buffer, len)) continue;
            if (i == Long.MAX_VALUE) {
                i = 0L;
                cons.accept(buffer, i);
                continue;
            }
            cons.accept(buffer, i++);
        }
    }

    public void readAllRecord(BiConsumer<Row, Long> cons) throws IOException {
        int len;
        long i = 0L;
        FixedByteLengthFileSetting setting = this.getCharsetSetting().clone();
        byte[] buffer = setting.createBuffer();
        while ((len = this.bis.read(buffer)) > 0) {
            Row row = this.getSetting().toRow(buffer);
            if (i == Long.MAX_VALUE) {
                i = 0L;
                cons.accept(row, i);
                continue;
            }
            cons.accept(row, i++);
        }
    }

    @Override
    public void close() {
        FileUtils.close(this.bis);
    }
}

