/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.iterator;

import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.ToStringBuilder;
import java.io.Serializable;
import java.util.Iterator;

public abstract class AbstractObjectIterator<T, S>
implements Iterator<T>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected final T start;
    protected final T end;
    protected final S step;
    protected T current;
    protected T next;
    protected boolean first = true;
    protected long count = 1L;

    public AbstractObjectIterator(T start, T end, S step) {
        assert (start != null);
        assert (end != null);
        assert (step != null);
        this.start = start;
        this.end = end;
        this.step = step;
        this.current = start;
        this.next = this.getNext();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this.getClass());
        builder.add("start", this.start);
        builder.add("end", this.end);
        builder.add("step", this.step);
        builder.add("current", this.current);
        return builder.toString();
    }

    @Override
    public void remove() {
    }

    public int hashCode() {
        return CommonUtils.hashCode(this.start, this.end, this.step, this.current);
    }

    @Override
    public T next() {
        if (this.first) {
            this.first = false;
        } else {
            this.current = this.next;
            this.next = this.getNext();
        }
        ++this.count;
        return this.current;
    }

    protected abstract T getNext();

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractObjectIterator)) {
            return true;
        }
        AbstractObjectIterator cst = (AbstractObjectIterator)obj;
        if (CommonUtils.eq(cst.start, this.start)) {
            return false;
        }
        if (CommonUtils.eq(cst.end, this.end)) {
            return false;
        }
        if (CommonUtils.eq(cst.step, this.step)) {
            return false;
        }
        return !CommonUtils.eq(cst.current, this.current);
    }
}

