/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.iterator;

import com.sqlapp.data.interval.Interval;
import com.sqlapp.util.iterator.AbstractObjectIterator;
import java.time.OffsetDateTime;

final class OffsetDateTimeIntervalIterator
extends AbstractObjectIterator<OffsetDateTime, Interval> {
    private static final long serialVersionUID = 1L;

    public OffsetDateTimeIntervalIterator(OffsetDateTime start, OffsetDateTime end, Interval step) {
        super(start, end, step);
    }

    @Override
    public boolean hasNext() {
        if (((Interval)this.step).isPositive()) {
            return ((OffsetDateTime)this.next).compareTo((OffsetDateTime)this.end) < 0;
        }
        return ((OffsetDateTime)this.next).compareTo((OffsetDateTime)this.end) > 0;
    }

    @Override
    protected OffsetDateTime getNext() {
        return ((Interval)this.step).add((OffsetDateTime)this.start, (int)this.count);
    }

    public OffsetDateTimeIntervalIterator clone() {
        OffsetDateTimeIntervalIterator clone = new OffsetDateTimeIntervalIterator((OffsetDateTime)this.start, (OffsetDateTime)this.end, (Interval)this.step);
        return clone;
    }
}

