/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.iterator;

import com.sqlapp.data.interval.Interval;
import com.sqlapp.util.iterator.AbstractObjectIterator;
import java.util.Date;

final class SqlDateIntervalIterator
extends AbstractObjectIterator<java.sql.Date, Interval> {
    private static final long serialVersionUID = 1L;

    public SqlDateIntervalIterator(java.sql.Date start, java.sql.Date end, Interval step) {
        super(start, end, step);
    }

    @Override
    public boolean hasNext() {
        if (((Interval)this.step).isPositive()) {
            return ((java.sql.Date)this.next).compareTo((Date)this.end) < 0;
        }
        return ((java.sql.Date)this.next).compareTo((Date)this.end) > 0;
    }

    @Override
    protected java.sql.Date getNext() {
        return ((Interval)this.step).add((java.sql.Date)this.start, (int)this.count);
    }

    public SqlDateIntervalIterator clone() {
        SqlDateIntervalIterator clone = new SqlDateIntervalIterator((java.sql.Date)this.start, (java.sql.Date)this.end, (Interval)this.step);
        return clone;
    }
}

