/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.iterator;

import com.sqlapp.util.DateUtils;
import com.sqlapp.util.iterator.AbstractObjectIterator;
import java.sql.Time;
import java.util.Date;

final class TimeIterator
extends AbstractObjectIterator<Time, Integer> {
    private static final long serialVersionUID = 1L;

    public TimeIterator(Time start, Time end) {
        this(start, end, 3600);
    }

    public TimeIterator(Time start, Time end, Integer step) {
        super(start, end, step);
    }

    @Override
    public boolean hasNext() {
        if ((Integer)this.step > 0) {
            if (((Time)this.start).compareTo((Date)this.next) >= 0) {
                return false;
            }
            if (((Time)this.next).compareTo((Date)this.end) < 0) {
                return true;
            }
        } else {
            if (((Time)this.start).compareTo((Date)this.next) <= 0) {
                return false;
            }
            if (((Time)this.next).compareTo((Date)this.end) > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected Time getNext() {
        return DateUtils.addSeconds((Time)this.current, (int)((Integer)this.step));
    }

    public TimeIterator clone() {
        TimeIterator clone = new TimeIterator((Time)this.start, (Time)this.end, (Integer)this.step);
        return clone;
    }
}

