/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.iterator;

import com.sqlapp.util.DateUtils;
import com.sqlapp.util.iterator.AbstractObjectIterator;
import java.sql.Timestamp;

final class TimestampIterator
extends AbstractObjectIterator<Timestamp, Integer> {
    private static final long serialVersionUID = 1L;

    public TimestampIterator(Timestamp start, Timestamp end) {
        this(start, end, 86400);
    }

    public TimestampIterator(Timestamp start, Timestamp end, Integer step) {
        super(start, end, step);
    }

    @Override
    public boolean hasNext() {
        if ((Integer)this.step > 0) {
            return ((Timestamp)this.next).compareTo((Timestamp)this.end) < 0;
        }
        return ((Timestamp)this.next).compareTo((Timestamp)this.end) > 0;
    }

    @Override
    protected Timestamp getNext() {
        return DateUtils.addSeconds((Timestamp)this.current, (int)((Integer)this.step));
    }

    public TimestampIterator clone() {
        TimestampIterator clone = new TimestampIterator((Timestamp)this.start, (Timestamp)this.end, (Integer)this.step);
        return clone;
    }
}

