/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.iterator;

import com.sqlapp.data.interval.Interval;
import com.sqlapp.util.iterator.AbstractObjectIterator;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;

final class ZonedDateTimeIntervalIterator
extends AbstractObjectIterator<ZonedDateTime, Interval> {
    private static final long serialVersionUID = 1L;

    public ZonedDateTimeIntervalIterator(ZonedDateTime start, ZonedDateTime end, Interval step) {
        super(start, end, step);
    }

    @Override
    public boolean hasNext() {
        if (((Interval)this.step).isPositive()) {
            return ((ZonedDateTime)this.next).compareTo((ChronoZonedDateTime)this.end) < 0;
        }
        return ((ZonedDateTime)this.next).compareTo((ChronoZonedDateTime)this.end) > 0;
    }

    @Override
    protected ZonedDateTime getNext() {
        return ((Interval)this.step).add((ZonedDateTime)this.start, (int)this.count);
    }

    public ZonedDateTimeIntervalIterator clone() {
        ZonedDateTimeIntervalIterator clone = new ZonedDateTimeIntervalIterator((ZonedDateTime)this.start, (ZonedDateTime)this.end, (Interval)this.step);
        return clone;
    }
}

