/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.xml;

import com.sqlapp.util.StaxReader;
import com.sqlapp.util.xml.AbstractStaxElementHandler;
import com.sqlapp.util.xml.StaxElementHandler;
import java.io.Serializable;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class EntryHandler
extends AbstractStaxElementHandler {
    @Override
    public String getLocalName() {
        return "entry";
    }

    @Override
    protected void doHandle(StaxReader reader, Object parentObject) throws XMLStreamException {
        Entry<String, String> result = new Entry<String, String>();
        if (reader.isStartElement()) {
            int size = reader.getAttributeCount();
            for (int i = 0; i < size; ++i) {
                String attributeLocalName = reader.getAttributeLocalName(i);
                String attributeValue = reader.getAttributeValue(i);
                if ("key".equalsIgnoreCase(attributeLocalName)) {
                    result.setKey(attributeValue);
                    continue;
                }
                if (!"value".equalsIgnoreCase(attributeLocalName)) continue;
                result.setValue(attributeValue);
            }
            reader.next();
            if (reader.isCharacters()) {
                result.setValue(reader.getText());
                reader.next();
            }
        }
        if (this.match(reader) && reader.isEndElement()) {
            reader.next();
        }
        this.callParent(reader, this.getLocalName(), parentObject, result);
    }

    @Override
    public void doCallback(StaxReader reader, StaxElementHandler child, String name, Object parentObject, Object value) throws XMLStreamException {
    }

    static class Entry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private K key;
        private V value;

        public Entry() {
        }

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        public void setKey(K key) {
            this.key = key;
        }

        @Override
        public V setValue(V value) {
            this.value = value;
            return null;
        }
    }
}

