/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.xml;

import com.sqlapp.util.CommonUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SimpleXMLStreamWriter
implements XMLStreamWriter {
    private Writer writer = null;
    private OutputStream outputStream = null;
    private Deque<ElementStatus> elementStack = new LinkedList<ElementStatus>();

    public SimpleXMLStreamWriter(Writer writer) {
        this.writer = writer;
    }

    public SimpleXMLStreamWriter(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    private SimpleXMLStreamWriter writeInternal(String value) {
        try {
            if (value == null) {
                return this;
            }
            if (this.writer != null) {
                this.writer.append(value);
            }
            if (this.outputStream != null) {
                this.outputStream.write(value.getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    private String replaceInvalidCharacter(String text) {
        if (text == null) {
            return null;
        }
        return CommonUtils.replaceInvalidCharacter(text);
    }

    private String escape(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        StringBuilder builder = new StringBuilder((int)((double)text.length() * 1.2));
        int size = text.codePointCount(0, text.length());
        for (int i = 0; i < size; ++i) {
            int codePoint = text.codePointAt(i);
            if (codePoint == 60) {
                builder.append("&lt;");
                continue;
            }
            if (codePoint == 38) {
                builder.append("&amp;");
                continue;
            }
            if (codePoint == 62) {
                builder.append("&gt;");
                continue;
            }
            if (codePoint == 34) {
                builder.append("&quot;");
                continue;
            }
            if (codePoint == 10) {
                builder.appendCodePoint(codePoint);
                continue;
            }
            if (codePoint == 9) {
                builder.appendCodePoint(codePoint);
                continue;
            }
            if (Character.isISOControl(codePoint)) continue;
            builder.appendCodePoint(codePoint);
        }
        return builder.toString();
    }

    private String escapeAttributeValue(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        StringBuilder builder = new StringBuilder((int)((double)text.length() * 1.2));
        int size = text.codePointCount(0, text.length());
        for (int i = 0; i < size; ++i) {
            int codePoint = text.codePointAt(i);
            if (codePoint == 60) {
                builder.append("&lt;");
                continue;
            }
            if (codePoint == 38) {
                builder.append("&amp;");
                continue;
            }
            if (codePoint == 62) {
                builder.append("&gt;");
                continue;
            }
            if (codePoint == 34) {
                builder.append("&quot;");
                continue;
            }
            if (Character.isISOControl(codePoint)) continue;
            builder.appendCodePoint(codePoint);
        }
        return builder.toString();
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        ElementStatus elementStatus = this.elementStack.peek();
        if (elementStatus != null && !elementStatus.isClose()) {
            elementStatus.setClose(true);
            this.writeInternal(">");
        }
        this.writeInternal("<").writeInternal(localName);
        elementStatus = new ElementStatus(localName);
        this.elementStack.push(elementStatus);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        throw new UnsupportedOperationException("writeStartElement(namespaceURI, localName)");
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        throw new UnsupportedOperationException("writeStartElement(prefix, namespaceURI, localName)");
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        throw new UnsupportedOperationException("writeStartElement(prefix, namespaceURI, localName)");
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        throw new UnsupportedOperationException("writeStartElement(prefix, namespaceURI, localName)");
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.closeStartElement();
        this.writeInternal("<").writeInternal(localName).writeInternal("/>");
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        ElementStatus elementStatus = this.elementStack.pop();
        if (elementStatus.isClose()) {
            this.writeInternal("</").writeInternal(elementStatus.getElementName()).writeInternal(">");
        } else {
            this.writeInternal("/>");
        }
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
    }

    @Override
    public void close() throws XMLStreamException {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public void flush() throws XMLStreamException {
        try {
            if (this.writer != null) {
                this.writer.flush();
            }
            if (this.outputStream != null) {
                this.outputStream.flush();
            }
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        ElementStatus elementStatus = this.elementStack.peek();
        elementStatus.addAttributeName(localName);
        this.writeInternal(" ").writeInternal(localName).writeInternal("=").writeInternal("\"").writeInternal(this.escapeAttributeValue(value)).writeInternal("\"");
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        throw new UnsupportedOperationException("writeStartElement(prefix, namespaceURI, localName)");
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        throw new UnsupportedOperationException("writeAttribute(namespaceURI, localName, value)");
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        throw new UnsupportedOperationException("writeNamespace(prefix, namespaceURI)");
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        throw new UnsupportedOperationException("writeDefaultNamespace(namespaceURI)");
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.writeInternal("<!--").writeInternal(this.escape(data)).writeInternal("-->");
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        throw new UnsupportedOperationException("writeProcessingInstruction(target)");
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        throw new UnsupportedOperationException("writeStartElement(prefix, namespaceURI, localName)");
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.closeStartElement();
        this.writeInternal("<![CDATA[");
        this.writeInternal(this.replaceInvalidCharacter(data).replace("]]>", "]]&gt;"));
        this.writeInternal("]]>");
    }

    private void closeStartElement() {
        ElementStatus elementStatus = this.elementStack.peek();
        if (elementStatus != null && !elementStatus.isClose()) {
            this.writeInternal(">");
            elementStatus.setClose(true);
        }
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        throw new UnsupportedOperationException("writeStartElement(prefix, namespaceURI, localName)");
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        throw new UnsupportedOperationException("writeStartElement(prefix, namespaceURI, localName)");
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.writeStartDocument("1.0");
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.writeStartDocument("utf-8", version);
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.writeInternal("<?xml version=\"" + version + "\" encoding=\"" + encoding + "\"?>");
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.closeStartElement();
        this.writeInternal(this.escape(text));
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        throw new UnsupportedOperationException("writeCharacters(text, start, len)");
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        throw new UnsupportedOperationException("getPrefix(uri)");
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        throw new UnsupportedOperationException("setPrefix(prefix, uri)");
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        throw new UnsupportedOperationException("setDefaultNamespace(uri)");
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        throw new UnsupportedOperationException("setNamespaceContext(context)");
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        throw new UnsupportedOperationException("getNamespaceContext()");
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        throw new UnsupportedOperationException("getProperty(name)");
    }

    static class ElementStatus {
        private String elementName;
        private Set<String> attributeNames;
        private boolean close = false;

        ElementStatus(String elementName) {
            this.elementName = elementName;
        }

        public void addAttributeName(String attributeName) {
            if (this.attributeNames == null) {
                this.attributeNames = CommonUtils.linkedSet();
            }
            this.attributeNames.add(attributeName);
        }

        public String getElementName() {
            return this.elementName;
        }

        public void setElementName(String elementName) {
            this.elementName = elementName;
        }

        public Set<String> getAttributeNames() {
            return this.attributeNames;
        }

        public void setAttributeNames(Set<String> attributeNames) {
            this.attributeNames = attributeNames;
        }

        public boolean isClose() {
            return this.close;
        }

        public void setClose(boolean close) {
            this.close = close;
        }
    }
}

