/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractConverter;
import com.sqlapp.data.converter.NewValue;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.Java8DateUtils;
import java.text.ParsePosition;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractJava8DateConverter<T extends Temporal, S>
extends AbstractConverter<T>
implements NewValue<T>,
Cloneable {
    private static final long serialVersionUID = -8249231108644220313L;
    private DateTimeFormatter[] parseFormats = Java8DateUtils.getDateTimeFormatters("yyyy-MM-dd HH:mm:ss");
    private DateTimeFormatter format = null;
    protected static final Pattern NUMBER_PATTERN = Pattern.compile("\\+?[0-9]+");
    protected static final ZoneId INSTANT_ZONE_ID = ZoneId.of("Z");
    protected static final ZoneOffset INSTANT_ZONE_OFFSET = INSTANT_ZONE_ID.getRules().getOffset(Instant.now());
    protected static final LocalDate EPOC_DAY = LocalDate.ofEpochDay(0L);
    protected static final LocalTime EPOC_TIME = LocalTime.of(0, 0);
    protected static final LocalDateTime EPOC_DATE = LocalDateTime.of(EPOC_DAY, EPOC_TIME);
    private boolean useSystemZone = true;

    protected T parseDate(String value) {
        int size = this.parseFormats.length;
        DateTimeParseException ext = null;
        for (int i = 0; i < size; ++i) {
            try {
                DateTimeFormatter dateTimeFormatter = this.parseFormats[i];
                T dateTime = this.parse(value, dateTimeFormatter);
                if (dateTime == null) continue;
                return dateTime;
            }
            catch (DateTimeParseException e) {
                if (ext != null) continue;
                ext = e;
            }
        }
        String message = this.getClass().getSimpleName() + "#parseDate Unparseable date: \"" + value + "\"";
        throw new UnsupportedOperationException(message, ext);
    }

    protected abstract T parse(String var1, DateTimeFormatter var2);

    public DateTimeFormatter[] getParseFormats() {
        return this.parseFormats;
    }

    public S setParseFormats(String ... parseFormats) {
        return this.setParseFormats(Java8DateUtils.getDateTimeFormatters(parseFormats));
    }

    protected abstract String format(T var1, DateTimeFormatter var2);

    @Override
    public String convertString(T value) {
        if (value == null) {
            return null;
        }
        if (this.getFormat() == null) {
            return value.toString();
        }
        String result = this.format(value, this.getFormat());
        return result;
    }

    protected boolean isUseSystemZone() {
        return this.useSystemZone;
    }

    protected S setUseSystemZone(boolean useSystemZone) {
        this.useSystemZone = useSystemZone;
        return this.instance();
    }

    public S setParseFormats(Object ... parseFormats) {
        if (CommonUtils.isEmpty(parseFormats)) {
            return this.instance();
        }
        List<DateTimeFormatter> formatters = CommonUtils.list();
        for (Object parseFormat : parseFormats) {
            if (CommonUtils.isEmpty(parseFormat)) continue;
            if (parseFormat instanceof DateTimeFormatter) {
                formatters.add((DateTimeFormatter)parseFormat);
                continue;
            }
            if (parseFormat instanceof String) {
                formatters.add(Java8DateUtils.getDateTimeFormatter((String)parseFormat));
                continue;
            }
            throw new IllegalArgumentException("parseFormats must String or DateTimeFormatter.[" + Arrays.toString(parseFormats) + "]");
        }
        return this.setParseFormats(formatters.toArray(new DateTimeFormatter[0]));
    }

    public S addParseFormat(Object parseFormat) {
        return this.addParseFormat(CommonUtils.size(this.parseFormats), parseFormat);
    }

    public S addParseFormat(int index, Object parseFormat) {
        if (CommonUtils.isEmpty(parseFormat)) {
            return this.instance();
        }
        List<Object> formatters = this.parseFormats != null ? CommonUtils.list(this.parseFormats) : CommonUtils.list();
        if (parseFormat instanceof DateTimeFormatter) {
            formatters.add(index, (DateTimeFormatter)parseFormat);
        } else if (parseFormat instanceof String) {
            formatters.add(index, Java8DateUtils.getDateTimeFormatter((String)parseFormat));
        } else {
            throw new IllegalArgumentException("parseFormats must String or DateTimeFormatter.[" + Arrays.toString(this.parseFormats) + "]");
        }
        return this.setParseFormats(formatters.toArray(new DateTimeFormatter[0]));
    }

    public S setParseFormats(DateTimeFormatter ... parseFormats) {
        if (!CommonUtils.isEmpty(parseFormats)) {
            this.parseFormats = CommonUtils.linkedSet(parseFormats).toArray(new DateTimeFormatter[0]);
            if (this.getFormat() != null) {
                this.setFormat(CommonUtils.first(parseFormats));
            }
        } else {
            this.parseFormats = parseFormats;
        }
        return this.instance();
    }

    protected static String convertUtcFormat(String text) {
        if (text.endsWith("+00:00")) {
            return text.substring(0, text.length() - 6) + "Z";
        }
        if (text.endsWith("+0000")) {
            return text.substring(0, text.length() - 5) + "Z";
        }
        return text;
    }

    protected S instance() {
        return (S)this;
    }

    public DateTimeFormatter getFormat() {
        return this.format;
    }

    public S setFormat(DateTimeFormatter format) {
        this.format = format;
        return this.instance();
    }

    public S setFormat(String format) {
        this.format = Java8DateUtils.getDateTimeFormatter(format);
        if (this.format != null && CommonUtils.isEmpty(this.getParseFormats())) {
            this.setParseFormats(this.format);
        }
        return this.instance();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AbstractJava8DateConverter)) {
            return false;
        }
        AbstractJava8DateConverter con = (AbstractJava8DateConverter)CommonUtils.cast(obj);
        if (!CommonUtils.eq(this.getParseFormats(), con.getParseFormats())) {
            return false;
        }
        return CommonUtils.eq(this.getFormat(), con.getFormat());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    protected int getChronoField(TemporalAccessor temporalAccessor, ChronoField chronoField) {
        if (temporalAccessor.isSupported(chronoField)) {
            return temporalAccessor.get(chronoField);
        }
        return 0;
    }

    protected boolean hasYearToDayPart(TemporalAccessor temporalAccessor) {
        return this.hasYear(temporalAccessor) || this.hasMonth(temporalAccessor) || this.hasDayOfMonth(temporalAccessor);
    }

    protected boolean hasTimePart(TemporalAccessor temporalAccessor) {
        return this.hasHour(temporalAccessor) || this.hasMinute(temporalAccessor) || this.hasSecond(temporalAccessor) || this.hasNanoSecond(temporalAccessor);
    }

    protected boolean hasYear(TemporalAccessor temporalAccessor) {
        if (temporalAccessor.isSupported(ChronoField.YEAR_OF_ERA)) {
            return true;
        }
        return temporalAccessor.isSupported(ChronoField.YEAR);
    }

    protected boolean hasMonth(TemporalAccessor temporalAccessor) {
        return temporalAccessor.isSupported(ChronoField.MONTH_OF_YEAR);
    }

    protected boolean hasDayOfMonth(TemporalAccessor temporalAccessor) {
        return temporalAccessor.isSupported(ChronoField.DAY_OF_MONTH);
    }

    protected boolean hasHour(TemporalAccessor temporalAccessor) {
        return temporalAccessor.isSupported(ChronoField.HOUR_OF_DAY);
    }

    protected boolean hasMinute(TemporalAccessor temporalAccessor) {
        return temporalAccessor.isSupported(ChronoField.MINUTE_OF_HOUR);
    }

    protected boolean hasSecond(TemporalAccessor temporalAccessor) {
        return temporalAccessor.isSupported(ChronoField.SECOND_OF_MINUTE);
    }

    protected boolean hasNanoSecond(TemporalAccessor temporalAccessor) {
        return temporalAccessor.isSupported(ChronoField.NANO_OF_SECOND);
    }

    protected boolean hasOffsetSeconds(TemporalAccessor temporalAccessor) {
        return temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS);
    }

    protected int getYear(TemporalAccessor temporalAccessor) {
        if (temporalAccessor.isSupported(ChronoField.YEAR_OF_ERA)) {
            return temporalAccessor.get(ChronoField.YEAR_OF_ERA);
        }
        return this.getChronoField(temporalAccessor, ChronoField.YEAR);
    }

    protected int getMonth(TemporalAccessor temporalAccessor) {
        return this.getChronoField(temporalAccessor, ChronoField.MONTH_OF_YEAR);
    }

    protected int getDayOfMonth(TemporalAccessor temporalAccessor) {
        return this.getChronoField(temporalAccessor, ChronoField.DAY_OF_MONTH);
    }

    protected int getHour(TemporalAccessor temporalAccessor) {
        return this.getChronoField(temporalAccessor, ChronoField.HOUR_OF_DAY);
    }

    protected int getMinute(TemporalAccessor temporalAccessor) {
        return this.getChronoField(temporalAccessor, ChronoField.MINUTE_OF_HOUR);
    }

    protected int getSecond(TemporalAccessor temporalAccessor) {
        return this.getChronoField(temporalAccessor, ChronoField.SECOND_OF_MINUTE);
    }

    protected int getNanoSecond(TemporalAccessor temporalAccessor) {
        return this.getChronoField(temporalAccessor, ChronoField.NANO_OF_SECOND);
    }

    protected Temporal parseTemporal(String value, DateTimeFormatter dateTimeFormatter) {
        ParsePosition position = new ParsePosition(0);
        TemporalAccessor temporalAccessor = dateTimeFormatter.parseUnresolved(value, position);
        if (position.getErrorIndex() < 0) {
            int year = this.getYear(temporalAccessor);
            int month = this.getMonth(temporalAccessor);
            int dayOfMonth = this.getDayOfMonth(temporalAccessor);
            int hour = this.getHour(temporalAccessor);
            int minute = this.getMinute(temporalAccessor);
            int second = this.getSecond(temporalAccessor);
            int nanoOfSecond = this.getNanoSecond(temporalAccessor);
            int offset = this.getChronoField(temporalAccessor, ChronoField.OFFSET_SECONDS);
            ZoneId zoneId = temporalAccessor.query(TemporalQueries.zoneId());
            ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(offset);
            if (!this.hasYearToDayPart(temporalAccessor)) {
                LocalTime localTime = LocalTime.of(hour, minute, second, nanoOfSecond);
                if (zoneId == null) {
                    if (this.hasOffsetSeconds(temporalAccessor)) {
                        return OffsetTime.of(localTime, zoneOffset);
                    }
                    return localTime;
                }
                if (this.hasOffsetSeconds(temporalAccessor)) {
                    return OffsetTime.of(localTime, zoneOffset);
                }
                return OffsetTime.of(localTime, zoneId.getRules().getOffset(Instant.now()));
            }
            if (!this.hasTimePart(temporalAccessor) && this.hasYear(temporalAccessor)) {
                if (this.hasMonth(temporalAccessor)) {
                    if (this.hasDayOfMonth(temporalAccessor)) {
                        return LocalDate.of(year, month, dayOfMonth);
                    }
                    return YearMonth.of(year, month);
                }
                return Year.of(year);
            }
            if (zoneId == null && !this.hasOffsetSeconds(temporalAccessor)) {
                return LocalDateTime.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond);
            }
            if (this.hasOffsetSeconds(temporalAccessor)) {
                if (zoneId == null) {
                    return OffsetDateTime.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond, zoneOffset);
                }
                LocalDateTime localDateTime = LocalDateTime.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond);
                return ZonedDateTime.ofStrict(localDateTime, zoneOffset, zoneId);
            }
            if (zoneId == null) {
                return LocalDateTime.of(year, month, dayOfMonth, hour, minute, second);
            }
            return ZonedDateTime.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond, zoneId);
        }
        return null;
    }

    protected ZoneId getDefaultZoneId() {
        if (this.isUseSystemZone()) {
            return ZoneId.systemDefault();
        }
        return INSTANT_ZONE_ID;
    }

    protected ZoneOffset getDefaultZoneOffset() {
        if (this.isUseSystemZone()) {
            return ZoneId.systemDefault().getRules().getOffset(Instant.now());
        }
        return INSTANT_ZONE_OFFSET;
    }

    protected ZonedDateTime toZonedDateTime(Instant date) {
        return ZonedDateTime.ofInstant(date, this.getDefaultZoneId());
    }

    protected ZonedDateTime toZonedDateTime(Number value) {
        Instant ins = Instant.ofEpochMilli(value.longValue());
        return this.toZonedDateTime(ins);
    }

    protected ZonedDateTime toZonedDateTime(OffsetDateTime date) {
        return ZonedDateTime.of(date.toLocalDateTime(), date.getOffset());
    }

    protected ZonedDateTime toZonedDateTime(LocalDateTime date) {
        return ZonedDateTime.of(date, this.getDefaultZoneId());
    }

    protected ZonedDateTime toZonedDateTime(ChronoLocalDate date) {
        if (date instanceof LocalDate) {
            return this.toZonedDateTime((LocalDate)date);
        }
        return this.toZonedDateTime(LocalDateTime.of(this.getYear(date), this.getMonth(date), this.getDayOfMonth(date), 0, 0));
    }

    protected ZonedDateTime toZonedDateTime(LocalTime time) {
        return ZonedDateTime.of(LocalDateTime.of(EPOC_DAY, time), this.getDefaultZoneId());
    }

    protected ZonedDateTime toZonedDateTime(OffsetTime time) {
        return ZonedDateTime.of(LocalDateTime.of(EPOC_DAY, time.toLocalTime()), time.getOffset());
    }

    protected ZonedDateTime toZonedDateTime(Calendar cal) {
        if (cal instanceof GregorianCalendar) {
            return ((GregorianCalendar)cal).toZonedDateTime();
        }
        ZoneId zoneId = cal.getTimeZone().toZoneId();
        return ZonedDateTime.ofInstant(cal.toInstant(), zoneId);
    }

    protected ZonedDateTime toZonedDateTime(LocalDate date) {
        return ZonedDateTime.of(this.toLocalDateTime(date), this.getDefaultZoneId());
    }

    protected ZonedDateTime toZonedDateTime(YearMonth date) {
        return ZonedDateTime.of(this.toLocalDateTime(date), this.getDefaultZoneId());
    }

    protected ZonedDateTime toZonedDateTime(Year date) {
        return ZonedDateTime.of(this.toLocalDateTime(date), this.getDefaultZoneId());
    }

    protected LocalDateTime toLocalDateTime(LocalDate date) {
        return LocalDateTime.of(date.getYear(), date.getMonth(), date.getDayOfMonth(), 0, 0);
    }

    protected LocalDateTime toLocalDateTime(YearMonth date) {
        return LocalDateTime.of(date.getYear(), date.getMonth(), 1, 0, 0);
    }

    protected LocalDateTime toLocalDateTime(Year date) {
        return LocalDateTime.of(date.getValue(), 1, 1, 0, 0);
    }

    protected OffsetDateTime toOffsetDateTime(LocalDateTime date) {
        return OffsetDateTime.of(date, this.getDefaultZoneOffset());
    }

    protected ZonedDateTime toZonedDateTime(Temporal temporal) {
        if (temporal == null) {
            return null;
        }
        if (temporal instanceof ZonedDateTime) {
            return (ZonedDateTime)ZonedDateTime.class.cast(temporal);
        }
        if (temporal instanceof Instant) {
            return this.toZonedDateTime((Instant)temporal);
        }
        if (temporal instanceof OffsetDateTime) {
            return this.toZonedDateTime((OffsetDateTime)temporal);
        }
        if (temporal instanceof LocalDateTime) {
            return this.toZonedDateTime((LocalDateTime)temporal);
        }
        if (temporal instanceof ChronoLocalDate) {
            return this.toZonedDateTime((ChronoLocalDate)temporal);
        }
        if (temporal instanceof LocalTime) {
            return this.toZonedDateTime((LocalTime)temporal);
        }
        if (temporal instanceof OffsetTime) {
            return this.toZonedDateTime((OffsetTime)temporal);
        }
        throw new IllegalArgumentException("temporal can not convert ZonedDateTime. temporal=[" + temporal + "]");
    }

    protected OffsetTime toOffsetTime(ZonedDateTime dateTime) {
        return OffsetTime.ofInstant(dateTime.toInstant(), dateTime.getZone());
    }

    public AbstractJava8DateConverter<T, S> clone() {
        try {
            return (AbstractJava8DateConverter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean isCurrentText(String text) {
        if ("now".equals(text)) {
            return true;
        }
        if (text.startsWith("current")) {
            return true;
        }
        return text.startsWith("sys");
    }

    protected boolean isNumberPattern(String text) {
        Matcher matcher = NUMBER_PATTERN.matcher(text);
        return matcher.matches();
    }

    protected Instant toInstant(String value) {
        Instant ins = Instant.ofEpochMilli(Long.parseLong(value));
        return ins;
    }

    @Override
    public T copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return (T)((Temporal)obj);
    }
}

