/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractConverter;
import com.sqlapp.util.CommonUtils;
import java.text.NumberFormat;
import java.text.ParseException;

public abstract class AbstractNumberConverter<T extends Number>
extends AbstractConverter<T> {
    private static final long serialVersionUID = -4360446065570122729L;
    private NumberFormat numberFormat = null;

    protected synchronized Number parse(String value) {
        try {
            return this.numberFormat.parse(value);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized String format(Number value) {
        return this.numberFormat.format(value);
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
        if (numberFormat != null) {
            this.numberFormat.setParseIntegerOnly(this.getParseIntegerOnly());
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractNumberConverter)) {
            return false;
        }
        AbstractNumberConverter con = (AbstractNumberConverter)CommonUtils.cast(obj);
        return CommonUtils.eq(this.getNumberFormat(), con.getNumberFormat());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    protected abstract boolean getParseIntegerOnly();

    protected String trim(String text) {
        String val = text.trim();
        if (val.startsWith("+")) {
            return val.substring(1);
        }
        return val;
    }
}

