/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractNumberConverter;
import com.sqlapp.util.CommonUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class BigDecimalConverter
extends AbstractNumberConverter<BigDecimal> {
    private static final long serialVersionUID = 1406845674338998578L;

    @Override
    public BigDecimal convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (BigDecimal)this.getDefaultValue();
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof String) {
            return this.convert(((String)value).trim());
        }
        if (value instanceof Float) {
            return BigDecimal.valueOf(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return BigDecimal.valueOf((Double)value);
        }
        if (value instanceof Number) {
            return BigDecimal.valueOf(((Number)value).longValue());
        }
        if (value instanceof OptionalInt) {
            OptionalInt op = (OptionalInt)value;
            return op.isPresent() ? BigDecimal.valueOf(op.getAsInt()) : null;
        }
        if (value instanceof OptionalLong) {
            OptionalLong op = (OptionalLong)value;
            return op.isPresent() ? BigDecimal.valueOf(op.getAsLong()) : null;
        }
        if (value instanceof OptionalDouble) {
            OptionalDouble op = (OptionalDouble)value;
            return op.isPresent() ? BigDecimal.valueOf(op.getAsDouble()) : null;
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return BigDecimal.ONE;
            }
            return BigDecimal.ZERO;
        }
        return this.convert(value.toString());
    }

    private BigDecimal convert(String value) {
        if (this.getNumberFormat() == null) {
            return new BigDecimal(value);
        }
        DecimalFormat format = (DecimalFormat)this.getNumberFormat();
        format.setParseBigDecimal(true);
        return (BigDecimal)this.parse(value);
    }

    @Override
    public String convertString(BigDecimal value) {
        if (value == null) {
            return null;
        }
        if (this.getNumberFormat() == null) {
            return value.toPlainString();
        }
        return this.format(value);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(this)) {
            return false;
        }
        return obj instanceof BigDecimalConverter;
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public BigDecimal copy(Object obj) {
        return this.convertObject(obj);
    }

    @Override
    protected boolean getParseIntegerOnly() {
        return false;
    }
}

