/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractDateConverter;
import com.sqlapp.data.converter.NewValue;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DateUtils;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;

public class DateConverter
extends AbstractDateConverter<Date, DateConverter>
implements NewValue<Date> {
    private static final long serialVersionUID = 1212274814940098554L;

    @Override
    public Date convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (Date)this.getDefaultValue();
        }
        if (value instanceof Date) {
            return new Date(((Date)value).getTime());
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        if (value instanceof Instant) {
            return Date.from((Instant)value);
        }
        if (value instanceof Number) {
            return DateUtils.toDate(((Number)value).longValue());
        }
        ZonedDateTime zonedDateTime = this.getZonedDateTimeConverter().convertObject(value);
        return this.toDate(zonedDateTime);
    }

    private Date toDate(ZonedDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return DateUtils.toDate(dateTime.toInstant().toEpochMilli());
    }

    public static DateConverter newInstance() {
        DateConverter dateConverter = new DateConverter();
        return dateConverter;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof DateConverter;
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public Date copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return (Date)this.convertObject(obj).clone();
    }

    @Override
    public Date newValue() {
        return new Date();
    }
}

