/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractConverter;
import com.sqlapp.data.interval.Interval;
import com.sqlapp.data.interval.IntervalHour;
import com.sqlapp.util.CommonUtils;

public class IntervalHourConverter
extends AbstractConverter<IntervalHour> {
    private static final long serialVersionUID = -1050734373259054536L;

    @Override
    public IntervalHour convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (IntervalHour)this.getDefaultValue();
        }
        if (value instanceof IntervalHour) {
            return (IntervalHour)value;
        }
        if (value instanceof Interval) {
            return IntervalHour.toHourType((Interval)value);
        }
        if (value instanceof String) {
            return IntervalHour.parse((String)value);
        }
        return this.convert(value.toString());
    }

    private IntervalHour convert(String value) {
        return IntervalHour.parse(value);
    }

    @Override
    public String convertString(IntervalHour value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(this)) {
            return false;
        }
        if (!(obj instanceof IntervalHourConverter)) {
            return false;
        }
        IntervalHourConverter con = (IntervalHourConverter)CommonUtils.cast(obj);
        return CommonUtils.eq(this.getDefaultValue(), con.getDefaultValue());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public IntervalHour copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.convertObject(obj).clone();
    }
}

