/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractConverter;
import com.sqlapp.data.interval.Interval;
import com.sqlapp.data.interval.IntervalSecond;
import com.sqlapp.util.CommonUtils;

public class IntervalSecondConverter
extends AbstractConverter<IntervalSecond> {
    private static final long serialVersionUID = -8270109209049314414L;

    @Override
    public IntervalSecond convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (IntervalSecond)this.getDefaultValue();
        }
        if (value instanceof IntervalSecond) {
            return (IntervalSecond)value;
        }
        if (value instanceof Interval) {
            return IntervalSecond.toSecondType((Interval)value);
        }
        if (value instanceof String) {
            return IntervalSecond.parse((String)value);
        }
        return this.convert(value.toString());
    }

    private IntervalSecond convert(String value) {
        return IntervalSecond.parse(value);
    }

    @Override
    public String convertString(IntervalSecond value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(this)) {
            return false;
        }
        if (!(obj instanceof IntervalSecondConverter)) {
            return false;
        }
        IntervalSecondConverter con = (IntervalSecondConverter)CommonUtils.cast(obj);
        return CommonUtils.eq(this.getDefaultValue(), con.getDefaultValue());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public IntervalSecond copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.convertObject(obj).clone();
    }
}

