/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractConverter;
import com.sqlapp.util.CommonUtils;
import java.util.Locale;

public class LocaleConverter
extends AbstractConverter<Locale> {
    private static final long serialVersionUID = -6423916550139552468L;
    private boolean toLanguageTag = true;

    @Override
    public Locale convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (Locale)this.getDefaultValue();
        }
        if (value instanceof Locale) {
            return (Locale)value;
        }
        return CommonUtils.getLocale(value.toString());
    }

    @Override
    public String convertString(Locale value) {
        if (value == null) {
            return null;
        }
        if (this.isToLanguageTag()) {
            String lang = value.toLanguageTag();
            if ("no".equals(lang)) {
                return "nb";
            }
            if ("no-NO".equals(lang)) {
                return "nb-NO";
            }
            return lang;
        }
        return value.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(this)) {
            return false;
        }
        if (!(obj instanceof LocaleConverter)) {
            return false;
        }
        LocaleConverter con = (LocaleConverter)CommonUtils.cast(obj);
        return CommonUtils.eq(this.getDefaultValue(), con.getDefaultValue());
    }

    public boolean isToLanguageTag() {
        return this.toLanguageTag;
    }

    public LocaleConverter setToLanguageTag(boolean toLanguageTag) {
        this.toLanguageTag = toLanguageTag;
        return this;
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public Locale copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.convertObject(obj);
    }
}

