/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractJava8OffsetConverter;
import com.sqlapp.data.converter.NewValue;
import com.sqlapp.util.CommonUtils;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Date;

public class OffsetDateTimeConverter
extends AbstractJava8OffsetConverter<OffsetDateTime, OffsetDateTimeConverter>
implements NewValue<OffsetDateTime> {
    private static final long serialVersionUID = 1212274814940098554L;

    @Override
    public OffsetDateTime convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (OffsetDateTime)this.getDefaultValue();
        }
        if (value instanceof OffsetDateTime) {
            return (OffsetDateTime)value;
        }
        if (value instanceof Instant) {
            return this.toZonedDateTime((Instant)value).toOffsetDateTime();
        }
        if (value instanceof ChronoLocalDate) {
            ChronoLocalDate localDate = (ChronoLocalDate)ChronoLocalDate.class.cast(value);
            Instant ins = Instant.ofEpochMilli(localDate.toEpochDay());
            return this.toZonedDateTime(ins).toOffsetDateTime();
        }
        if (value instanceof LocalDateTime) {
            return this.toZonedDateTime((LocalDateTime)value).toOffsetDateTime();
        }
        if (value instanceof OffsetDateTime) {
            return this.toZonedDateTime((OffsetDateTime)value).toOffsetDateTime();
        }
        if (value instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)ZonedDateTime.class.cast(value);
            return zonedDateTime.toOffsetDateTime();
        }
        if (value instanceof Calendar) {
            return this.toZonedDateTime((Calendar)value).toOffsetDateTime();
        }
        if (value instanceof java.sql.Date) {
            java.sql.Date dt = (java.sql.Date)java.sql.Date.class.cast(value);
            return this.toZonedDateTime(Instant.ofEpochMilli(dt.getTime())).toOffsetDateTime();
        }
        if (value instanceof Date) {
            Date dt = (Date)Date.class.cast(value);
            return this.toZonedDateTime(dt.toInstant()).toOffsetDateTime();
        }
        if (value instanceof Number) {
            return this.toZonedDateTime((Number)value).toOffsetDateTime();
        }
        if (value instanceof String) {
            String lowerVal = ((String)value).toLowerCase();
            if (this.isCurrentText(lowerVal)) {
                return OffsetDateTime.now();
            }
            if (lowerVal.startsWith("'") && lowerVal.endsWith("'")) {
                String val = (String)CommonUtils.cast(value);
                return (OffsetDateTime)this.parseDate(val.substring(1, val.length() - 1));
            }
            if (this.isNumberPattern(lowerVal)) {
                Instant ins = this.toInstant(lowerVal);
                return this.toZonedDateTime(ins).toOffsetDateTime();
            }
            return (OffsetDateTime)this.parseDate((String)value);
        }
        return (OffsetDateTime)this.parseDate(value.toString());
    }

    @Override
    protected ZoneOffset getDefaultZoneOffset() {
        return ZoneId.systemDefault().getRules().getOffset(Instant.now());
    }

    @Override
    protected OffsetDateTime toUtc(OffsetDateTime dateTime) {
        if (this.isUtc()) {
            if (dateTime == null) {
                return null;
            }
            return dateTime.withOffsetSameInstant(INSTANT_ZONE_OFFSET);
        }
        return dateTime;
    }

    public static OffsetDateTimeConverter newInstance() {
        OffsetDateTimeConverter dateConverter = new OffsetDateTimeConverter();
        return dateConverter;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof OffsetDateTimeConverter;
    }

    @Override
    public OffsetDateTime newValue() {
        return OffsetDateTime.now();
    }

    @Override
    protected OffsetDateTime parse(String value, DateTimeFormatter dateTimeFormatter) {
        Temporal temporal = this.parseTemporal(value, dateTimeFormatter);
        if (temporal == null) {
            return null;
        }
        if (temporal instanceof OffsetDateTime) {
            return (OffsetDateTime)OffsetDateTime.class.cast(temporal);
        }
        return this.toZonedDateTime(temporal).toOffsetDateTime();
    }

    @Override
    protected String format(OffsetDateTime temporal, DateTimeFormatter formatter) {
        return temporal.format(formatter);
    }
}

