/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractConverter;
import com.sqlapp.util.CommonUtils;
import java.time.ZoneId;
import java.util.TimeZone;

public class ZoneIdConverter
extends AbstractConverter<ZoneId> {
    private static final long serialVersionUID = 6136157088033787646L;

    @Override
    public ZoneId convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (ZoneId)this.getDefaultValue();
        }
        if (value instanceof ZoneId) {
            return (ZoneId)value;
        }
        if (value instanceof TimeZone) {
            return ((TimeZone)value).toZoneId();
        }
        return ZoneId.of(value.toString());
    }

    @Override
    public String convertString(ZoneId value) {
        if (value == null) {
            return null;
        }
        return value.getId();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(this)) {
            return false;
        }
        if (!(obj instanceof ZoneIdConverter)) {
            return false;
        }
        ZoneIdConverter con = (ZoneIdConverter)CommonUtils.cast(obj);
        return CommonUtils.eq(this.getDefaultValue(), con.getDefaultValue());
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public ZoneId copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.convertObject(obj);
    }
}

