/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.converter;

import com.sqlapp.data.converter.AbstractJava8OffsetConverter;
import com.sqlapp.data.converter.NewValue;
import com.sqlapp.util.CommonUtils;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Date;

public class ZonedDateTimeConverter
extends AbstractJava8OffsetConverter<ZonedDateTime, ZonedDateTimeConverter>
implements NewValue<ZonedDateTime> {
    private static final long serialVersionUID = 1212274814940098554L;

    @Override
    public ZonedDateTime convertObject(Object value) {
        if (CommonUtils.isEmpty(value)) {
            return (ZonedDateTime)this.getDefaultValue();
        }
        if (value instanceof Temporal) {
            if (value instanceof ZonedDateTime) {
                return (ZonedDateTime)value;
            }
            if (value instanceof Instant) {
                return this.toZonedDateTime((Instant)value);
            }
            if (value instanceof ChronoLocalDate) {
                return this.toZonedDateTime((ChronoLocalDate)value);
            }
            if (value instanceof LocalDateTime) {
                return this.toZonedDateTime((LocalDateTime)value);
            }
            if (value instanceof OffsetDateTime) {
                return this.toZonedDateTime((OffsetDateTime)value);
            }
            if (value instanceof YearMonth) {
                return this.toZonedDateTime((YearMonth)value);
            }
            if (value instanceof Year) {
                return this.toZonedDateTime((Year)value);
            }
        } else {
            if (value instanceof Calendar) {
                return this.toZonedDateTime((Calendar)value);
            }
            if (value instanceof java.sql.Date) {
                java.sql.Date dt = (java.sql.Date)java.sql.Date.class.cast(value);
                return this.toZonedDateTime(Instant.ofEpochMilli(dt.getTime()));
            }
            if (value instanceof Date) {
                Date dt = (Date)Date.class.cast(value);
                return this.toZonedDateTime(dt.toInstant());
            }
            if (value instanceof Number) {
                return this.toZonedDateTime((Number)value);
            }
            if (value instanceof String) {
                String lowerVal = ((String)value).toLowerCase();
                if (this.isCurrentText(lowerVal)) {
                    return ZonedDateTime.now();
                }
                if (lowerVal.startsWith("'") && lowerVal.endsWith("'")) {
                    String val = (String)CommonUtils.cast(value);
                    return (ZonedDateTime)this.parseDate(val.substring(1, val.length() - 1));
                }
                if (this.isNumberPattern(lowerVal)) {
                    Instant ins = this.toInstant(lowerVal);
                    return this.toZonedDateTime(ins);
                }
                return (ZonedDateTime)this.parseDate((String)value);
            }
        }
        return (ZonedDateTime)this.parseDate(value.toString());
    }

    @Override
    protected ZonedDateTime toUtc(ZonedDateTime dateTime) {
        if (this.isUtc()) {
            if (dateTime == null) {
                return null;
            }
            return dateTime.withZoneSameInstant(INSTANT_ZONE_ID);
        }
        return dateTime;
    }

    public static ZonedDateTimeConverter newInstance() {
        ZonedDateTimeConverter dateConverter = new ZonedDateTimeConverter();
        return dateConverter;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof ZonedDateTimeConverter;
    }

    @Override
    public ZonedDateTime newValue() {
        return ZonedDateTime.now();
    }

    @Override
    protected ZonedDateTime parse(String value, DateTimeFormatter dateTimeFormatter) {
        Temporal temporal = this.parseTemporal(value, dateTimeFormatter);
        if (temporal instanceof ZonedDateTime) {
            return (ZonedDateTime)ZonedDateTime.class.cast(temporal);
        }
        return this.toZonedDateTime(temporal);
    }

    @Override
    public ZonedDateTimeConverter clone() {
        return (ZonedDateTimeConverter)super.clone();
    }

    @Override
    protected String format(ZonedDateTime temporal, DateTimeFormatter formatter) {
        return temporal.format(formatter);
    }
}

