/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.datatype;

import com.sqlapp.data.db.datatype.DbDataType;
import com.sqlapp.data.db.datatype.PrecisionProperties;
import com.sqlapp.data.db.datatype.ScaleProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.properties.DataTypeLengthProperties;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StringUtils;
import java.util.regex.Matcher;

public abstract class AbstractPrecisionScaleType<T extends DbDataType<T>>
extends DbDataType<T>
implements PrecisionProperties<T>,
ScaleProperties<T> {
    private static final long serialVersionUID = 8982873757752848020L;
    private Integer defaultPrecision = null;
    private Integer maxPrecision = null;
    private int scale = 0;
    private Integer defaultScale = null;
    private Integer maxScale = null;

    @Override
    protected void initialize(String typeName) {
        this.setFixedPrecision(true);
        this.setFixedScale(true);
        this.setCreateFormat(typeName + "(", ",", ")");
        this.addFormats(typeName);
        this.addPrecisionScaleFormat(typeName);
        for (String alias : this.getDataType().getAliasNames()) {
            this.addPrecisionScaleFormat(alias);
        }
    }

    public T setCreateFormat(String start, String middle, String end) {
        this.setCreateFormat(start + "{p}" + middle + "{s}" + end);
        return this.instance();
    }

    @Override
    public boolean matchLength(DataTypeLengthProperties<?> column) {
        return column.getLength() != null && this.getMaxPrecision() != null && this.getMaxPrecision().longValue() - column.getLength() >= 0L;
    }

    @Override
    public Integer getDefaultPrecision() {
        return this.defaultPrecision;
    }

    @Override
    public T setDefaultPrecision(Integer defaultPrecision) {
        this.defaultPrecision = defaultPrecision;
        return this.instance();
    }

    @Override
    public Integer getMaxPrecision() {
        return this.maxPrecision;
    }

    @Override
    public T setMaxPrecision(Integer maxPrecision) {
        this.maxPrecision = maxPrecision;
        return this.instance();
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public T setScale(int scale) {
        this.scale = scale;
        return this.instance();
    }

    @Override
    public Integer getDefaultScale() {
        return this.defaultScale;
    }

    @Override
    public T setDefaultScale(Integer defaultScale) {
        this.defaultScale = defaultScale;
        return this.instance();
    }

    @Override
    public Integer getMaxScale() {
        return this.maxScale;
    }

    @Override
    public T setMaxScale(Integer maxScale) {
        this.maxScale = maxScale;
        return this.instance();
    }

    @Override
    public Integer getPrecision(Number precision) {
        return this.getProperNumber(this.getMaxPrecision(), this.getDefaultPrecision(), precision);
    }

    @Override
    public Integer getScale(Integer scale) {
        return this.getProperNumber(this.getMaxScale(), this.getDefaultScale(), scale);
    }

    @Override
    protected void parseAndSet(Matcher matcher, DataTypeLengthProperties<?> column) {
        Integer size;
        String val;
        if (matcher.groupCount() == 0) {
            if (this.getDefaultPrecision() != null) {
                column.setLength(this.getDefaultPrecision());
            }
            if (this.getDefaultScale() != null) {
                column.setScale(this.getDefaultScale());
            }
        } else if (!CommonUtils.eqIgnoreCase(column.getDataTypeName(), this.getTypeName())) {
            SchemaUtils.setDataTypeNameInternal(this.getTypeName(), column);
        }
        if (matcher.groupCount() > 0) {
            val = StringUtils.getGroupString(matcher, 1);
            size = CommonUtils.toInteger(val);
            if (size != null) {
                column.setLength(CommonUtils.min(size, this.getMaxPrecision()));
            } else {
                column.setLength(this.getDefaultPrecision());
            }
        }
        if (matcher.groupCount() > 1) {
            val = StringUtils.getGroupString(matcher, 2);
            size = CommonUtils.toInteger(val);
            if (size != null) {
                column.setScale(CommonUtils.min(size, this.getMaxScale()));
            } else {
                column.setScale(this.getDefaultScale());
            }
        }
    }

    @Override
    public T addPrecisionScaleFormat(String dataTypeName) {
        this.addFormats(dataTypeName + "\\s*\\(\\s*([0-9]+)\\s*,\\s*([0-9]+)\\s*\\)\\s*", dataTypeName + "\\s*\\(\\s*([0-9]+)\\s*\\)\\s*", dataTypeName + "\\s*");
        return (T)this;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AbstractPrecisionScaleType)) {
            return false;
        }
        AbstractPrecisionScaleType objValue = (AbstractPrecisionScaleType)obj;
        if (!CommonUtils.eq(this.getDefaultPrecision(), objValue.getDefaultPrecision())) {
            return false;
        }
        if (!CommonUtils.eq(this.getMaxPrecision(), objValue.getMaxPrecision())) {
            return false;
        }
        if (!CommonUtils.eq(this.getScale(), objValue.getScale())) {
            return false;
        }
        if (!CommonUtils.eq(this.getDefaultScale(), objValue.getDefaultScale())) {
            return false;
        }
        return CommonUtils.eq(this.getMaxScale(), objValue.getMaxScale());
    }
}

