/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.datatype;

import com.sqlapp.data.db.datatype.DbDataType;
import com.sqlapp.data.db.datatype.ScaleProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.properties.DataTypeLengthProperties;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StringUtils;
import java.util.regex.Matcher;

public abstract class AbstractScaleType<T extends DbDataType<T>>
extends DbDataType<T>
implements ScaleProperties<T> {
    private static final long serialVersionUID = 8982873757752848020L;
    private int scale = 0;
    private Integer defaultScale = null;
    private Integer maxScale = null;

    @Override
    protected void initialize(String typeName) {
        this.setCreateFormat(this.getCreateFormat(typeName + "(", ")"));
        this.setFixedScale(true);
        this.addFormats(typeName);
        this.addScaleFormat(typeName);
    }

    public String getCreateFormat(String start) {
        return start + "{s}";
    }

    public String getCreateFormat(String start, String end) {
        return start + "{s}" + end;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public T setScale(int scale) {
        this.scale = scale;
        return this.instance();
    }

    @Override
    public Integer getDefaultScale() {
        return this.defaultScale;
    }

    @Override
    public T setDefaultScale(Integer defaultScale) {
        this.defaultScale = defaultScale;
        return this.instance();
    }

    @Override
    public Integer getMaxScale() {
        return this.maxScale;
    }

    @Override
    public T setMaxScale(Integer maxScale) {
        this.maxScale = maxScale;
        return this.instance();
    }

    @Override
    protected void parseAndSet(Matcher matcher, DataTypeLengthProperties<?> column) {
        if (matcher.groupCount() == 0 && this.getDefaultScale() != null) {
            column.setScale(this.getDefaultScale());
        }
        if (matcher.groupCount() > 0) {
            String val = StringUtils.getGroupString(matcher, 1);
            Integer size = CommonUtils.toInteger(val);
            if (size != null) {
                column.setScale(CommonUtils.min(size, this.getMaxScale()));
            } else if (this.getDefaultScale() != null) {
                column.setScale(this.getDefaultScale());
            }
        } else if (!CommonUtils.eqIgnoreCase(column.getDataTypeName(), this.getTypeName())) {
            SchemaUtils.setDataTypeNameInternal(this.getTypeName(), column);
        }
    }

    @Override
    public Integer getScale(Integer scale) {
        return this.getProperNumber(this.getMaxScale(), this.getDefaultScale(), scale);
    }

    @Override
    public T addScaleFormat(String dataTypeName) {
        this.addFormats(dataTypeName + "\\s*\\(\\s*([0-9]+)\\s*\\)\\s*", dataTypeName + "\\s*");
        return (T)this;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AbstractScaleType)) {
            return false;
        }
        AbstractScaleType objValue = (AbstractScaleType)obj;
        if (!CommonUtils.eq(this.getScale(), objValue.getScale())) {
            return false;
        }
        if (!CommonUtils.eq(this.getDefaultScale(), objValue.getDefaultScale())) {
            return false;
        }
        return CommonUtils.eq(this.getMaxScale(), objValue.getMaxScale());
    }
}

