/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.datatype;

import com.sqlapp.data.converter.BooleanConverter;
import com.sqlapp.data.converter.Converter;
import com.sqlapp.data.db.datatype.AbstractNoSizeType;
import com.sqlapp.data.db.datatype.BitType;
import com.sqlapp.data.db.datatype.DataType;

public class BooleanType
extends AbstractNoSizeType<BooleanType> {
    private static final long serialVersionUID = -8658816953027318522L;
    protected Converter<Boolean> converter = new BooleanConverter();

    public BooleanType() {
        this(DataType.BOOLEAN.getTypeName());
    }

    public BooleanType(String dataTypeName) {
        this.setDataType(DataType.BOOLEAN);
        this.initialize(dataTypeName);
        this.setUnsigned(true);
        this.setDefaultValueLiteral("FALSE");
    }

    public BooleanType setAsStringType() {
        this.setJdbcTypeHandler(new BitType.BitStringTypeHandler(this.getDataType().getJdbcType(), this.converter));
        this.setDefaultValueLiteral("'0'");
        return this;
    }

    public BooleanType setAsNumericType() {
        this.setJdbcTypeHandler(new BitType.BitNumericTypeHandler(this.getDataType().getJdbcType(), this.converter));
        this.setDefaultValueLiteral("0");
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof BooleanType;
    }
}

