/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.datatype;

import com.sqlapp.data.db.datatype.AlphanumType;
import com.sqlapp.data.db.datatype.AnyDataType;
import com.sqlapp.data.db.datatype.ArrayType;
import com.sqlapp.data.db.datatype.BigIntType;
import com.sqlapp.data.db.datatype.BigSerialType;
import com.sqlapp.data.db.datatype.BinaryType;
import com.sqlapp.data.db.datatype.BitType;
import com.sqlapp.data.db.datatype.BlobType;
import com.sqlapp.data.db.datatype.BooleanType;
import com.sqlapp.data.db.datatype.BoxType;
import com.sqlapp.data.db.datatype.CharType;
import com.sqlapp.data.db.datatype.CidrType;
import com.sqlapp.data.db.datatype.CircleType;
import com.sqlapp.data.db.datatype.ClobType;
import com.sqlapp.data.db.datatype.DataLinkType;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.datatype.DateTimeType;
import com.sqlapp.data.db.datatype.DateType;
import com.sqlapp.data.db.datatype.DbDataType;
import com.sqlapp.data.db.datatype.DecimalFloatType;
import com.sqlapp.data.db.datatype.DecimalType;
import com.sqlapp.data.db.datatype.DoubleType;
import com.sqlapp.data.db.datatype.EnumType;
import com.sqlapp.data.db.datatype.FloatType;
import com.sqlapp.data.db.datatype.GeographyType;
import com.sqlapp.data.db.datatype.GeometryType;
import com.sqlapp.data.db.datatype.HugeIntType;
import com.sqlapp.data.db.datatype.InetType;
import com.sqlapp.data.db.datatype.IntType;
import com.sqlapp.data.db.datatype.IntervalDayToHourType;
import com.sqlapp.data.db.datatype.IntervalDayToMinuteType;
import com.sqlapp.data.db.datatype.IntervalDayToSecondType;
import com.sqlapp.data.db.datatype.IntervalDayType;
import com.sqlapp.data.db.datatype.IntervalHourToMinuteType;
import com.sqlapp.data.db.datatype.IntervalHourToSecondType;
import com.sqlapp.data.db.datatype.IntervalHourType;
import com.sqlapp.data.db.datatype.IntervalMinuteToSecondType;
import com.sqlapp.data.db.datatype.IntervalMinuteType;
import com.sqlapp.data.db.datatype.IntervalMonthType;
import com.sqlapp.data.db.datatype.IntervalSecondType;
import com.sqlapp.data.db.datatype.IntervalType;
import com.sqlapp.data.db.datatype.IntervalYearToDayType;
import com.sqlapp.data.db.datatype.IntervalYearToMonthType;
import com.sqlapp.data.db.datatype.IntervalYearType;
import com.sqlapp.data.db.datatype.JsonType;
import com.sqlapp.data.db.datatype.JsonbType;
import com.sqlapp.data.db.datatype.LengthProperties;
import com.sqlapp.data.db.datatype.LineType;
import com.sqlapp.data.db.datatype.LongNVarcharType;
import com.sqlapp.data.db.datatype.LongVarBinaryType;
import com.sqlapp.data.db.datatype.LongVarcharType;
import com.sqlapp.data.db.datatype.LsegType;
import com.sqlapp.data.db.datatype.MCharType;
import com.sqlapp.data.db.datatype.MVarcharType;
import com.sqlapp.data.db.datatype.MacAddrType;
import com.sqlapp.data.db.datatype.MediumIntType;
import com.sqlapp.data.db.datatype.MoneyType;
import com.sqlapp.data.db.datatype.NCharType;
import com.sqlapp.data.db.datatype.NClobType;
import com.sqlapp.data.db.datatype.NVarcharType;
import com.sqlapp.data.db.datatype.NumericType;
import com.sqlapp.data.db.datatype.PathType;
import com.sqlapp.data.db.datatype.PointType;
import com.sqlapp.data.db.datatype.PolygonType;
import com.sqlapp.data.db.datatype.RealType;
import com.sqlapp.data.db.datatype.RowIdType;
import com.sqlapp.data.db.datatype.RowVersionType;
import com.sqlapp.data.db.datatype.SearchableShortTextType;
import com.sqlapp.data.db.datatype.SearchableTextType;
import com.sqlapp.data.db.datatype.SerialType;
import com.sqlapp.data.db.datatype.SetType;
import com.sqlapp.data.db.datatype.SmallDateTimeType;
import com.sqlapp.data.db.datatype.SmallIntType;
import com.sqlapp.data.db.datatype.SmallMoneyType;
import com.sqlapp.data.db.datatype.SmallSerialType;
import com.sqlapp.data.db.datatype.SqlIdentifierType;
import com.sqlapp.data.db.datatype.SqlXmlType;
import com.sqlapp.data.db.datatype.TimeType;
import com.sqlapp.data.db.datatype.TimeWithTimeZoneType;
import com.sqlapp.data.db.datatype.TimestampType;
import com.sqlapp.data.db.datatype.TimestampVersionType;
import com.sqlapp.data.db.datatype.TimestampWithTimeZoneType;
import com.sqlapp.data.db.datatype.TinyIntType;
import com.sqlapp.data.db.datatype.UBigIntType;
import com.sqlapp.data.db.datatype.UIntType;
import com.sqlapp.data.db.datatype.UMediumIntType;
import com.sqlapp.data.db.datatype.USmallIntType;
import com.sqlapp.data.db.datatype.UTinyIntType;
import com.sqlapp.data.db.datatype.UUIDType;
import com.sqlapp.data.db.datatype.VarBinaryType;
import com.sqlapp.data.db.datatype.VarcharIgnorecaseType;
import com.sqlapp.data.db.datatype.VarcharType;
import com.sqlapp.data.db.datatype.YesOrNoType;
import com.sqlapp.data.schemas.properties.ArrayDimensionProperties;
import com.sqlapp.data.schemas.properties.DataTypeLengthProperties;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DoubleKeyMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Matcher;

public class DbDataTypeCollection
implements Serializable {
    private static final long serialVersionUID = -3422158399668303563L;
    private final Map<DataType, DataType> recommendMapping = CommonUtils.enumMap(DataType.class);
    private final Map<DataType, DbDataType<?>> dataTypeMap = CommonUtils.enumMap(DataType.class);
    private final Map<DataType, TreeMap<Long, DbDataType<?>>> dataLengthType = CommonUtils.enumMap(DataType.class);
    private transient Function<String, String> arrayPatternGenerator = new ArrayPatternGenerator();
    private transient BiConsumer<Matcher, ArrayDimensionProperties<?>> arrayDimensionHandler = new ArrayDimensionHandler();
    private final Map<DataType, DataType> surrogateMap = DataType.getSurrogateMap();
    private Map<String, DbDataType<?>> productDataTypeDbTypeCache = CommonUtils.map();
    private Set<String> noMatchProductDataTypeDbTypeCache = CommonUtils.set();
    private DoubleKeyMap<String, Long, DbDataType<?>> productDataLengthTypeDbTypeCache = CommonUtils.doubleKeyMap();

    public void setArrayPatternGenerator(Function<String, String> arrayPatternGenerator) {
        this.arrayPatternGenerator = arrayPatternGenerator;
    }

    public void setArrayDimensionHandler(BiConsumer<Matcher, ArrayDimensionProperties<?>> arrayDimensionHandler) {
        this.arrayDimensionHandler = arrayDimensionHandler;
    }

    protected Function<String, String> getArrayPatternGenerator() {
        return this.arrayPatternGenerator;
    }

    protected BiConsumer<Matcher, ArrayDimensionProperties<?>> getArrayDimensionHandler() {
        return this.arrayDimensionHandler;
    }

    public void registerRecommend(DataType baseType, DataType recommendType) {
        if (this.recommendMapping.containsKey((Object)baseType)) {
            this.recommendMapping.remove((Object)baseType);
        }
        this.recommendMapping.put(baseType, recommendType);
    }

    public DbDataType<?> getDbTypeStrict(DataType type) {
        if (this.dataTypeMap.containsKey((Object)type)) {
            DbDataType<?> dbType = this.dataTypeMap.get((Object)type);
            return dbType;
        }
        return null;
    }

    public DbDataType<?> getDbType(DataType type) {
        Set<DataType> typeSet = CommonUtils.set();
        return this.getDbType(type, typeSet);
    }

    private DbDataType<?> getDbType(DataType type, Set<DataType> typeSet) {
        if (type == null) {
            return null;
        }
        if (typeSet.contains((Object)type)) {
            return null;
        }
        DbDataType<?> dbType = this.dataTypeMap.get((Object)type);
        if (dbType != null) {
            if (dbType.isDeprecated()) {
                return dbType.getDeprecatedSurrogateType();
            }
            return dbType;
        }
        typeSet.add(type);
        DataType surrogate = type.getUpperSurrogate();
        DbDataType<?> result = this.getDbType(surrogate, typeSet);
        if (result != null) {
            return result;
        }
        surrogate = this.getSurrogateMap().get((Object)type);
        result = this.getDbType(surrogate, typeSet);
        if (result != null) {
            return result;
        }
        return this.getDbType(surrogate, typeSet);
    }

    public DbDataType<?> getDbTypeStrict(DataType type, Number columnSize) {
        if (columnSize == null) {
            return this.getDbTypeStrict(type);
        }
        return this.getDbTypeStrict(type, columnSize.longValue());
    }

    public DbDataType<?> getDbTypeStrict(DataType dataType, Long columnSize) {
        if (columnSize == null) {
            return this.getDbTypeStrict(dataType);
        }
        DbDataType<?> result = this.getDbTypeLengthInternal(dataType, columnSize);
        return result;
    }

    public DbDataType<?> getDbType(DataType dataType, Number columnSize) {
        if (columnSize == null) {
            return this.getDbType(dataType);
        }
        return this.getDbType(dataType, columnSize.longValue());
    }

    public DbDataType<?> getDbType(DataType dataType, Long columnSize) {
        Set<DataType> typeSet = CommonUtils.set();
        DbDataType<?> dbDataType = null;
        if ((columnSize == null || columnSize <= 0L) && (dbDataType = this.getDbType(dataType)) != null) {
            if (dbDataType instanceof LengthProperties) {
                LengthProperties lengthProperties = (LengthProperties)((Object)dbDataType);
                if (columnSize == null || lengthProperties.getMaxLength() == null || columnSize.compareTo(lengthProperties.getMaxLength()) <= 0) {
                    return dbDataType;
                }
            } else {
                return dbDataType;
            }
        }
        if ((dbDataType = this.getDbType(dataType, columnSize, typeSet)) == null) {
            dbDataType = this.getDbType(dataType);
        }
        return dbDataType;
    }

    private DbDataType<?> getDbType(DataType type, Long columnSize, Set<DataType> typeSet) {
        if (type == null) {
            return null;
        }
        if (typeSet.contains((Object)type)) {
            return null;
        }
        DataType surrogate = this.getSurrogateMap().get((Object)type);
        if (columnSize != null && columnSize >= 0L) {
            DbDataType<?> dbDataType = this.getDbTypeLengthInternal(type, columnSize, typeSet);
            if (dbDataType != null) {
                return dbDataType;
            }
            dbDataType = this.getDbTypeLengthInternal(type.getUpperSurrogate(), columnSize);
            if (dbDataType != null) {
                return dbDataType;
            }
            dbDataType = this.getDbTypeLengthInternal(type.getNationalSurrogate(), columnSize, typeSet);
            if (dbDataType != null) {
                return dbDataType;
            }
            if (type.getUpperSurrogate() != null && (dbDataType = this.getDbType(type.getUpperSurrogate(), columnSize, typeSet)) != null) {
                return dbDataType;
            }
            dbDataType = this.getDbType(surrogate, columnSize, typeSet);
            if (dbDataType != null) {
                return dbDataType;
            }
            return this.getMaxDbDataType(type, type.getUpperSurrogate(), surrogate);
        }
        typeSet.add(type);
        return this.getDbType(surrogate, typeSet);
    }

    private DbDataType<?> getDbTypeLengthInternal(DataType type, Long columnSize, Set<DataType> typeSet) {
        if (type == null) {
            return null;
        }
        if (typeSet.contains((Object)type)) {
            return null;
        }
        typeSet.add(type);
        return this.getDbTypeLengthInternal(type, columnSize);
    }

    private DbDataType<?> getMaxDbDataType(DataType ... types) {
        for (DataType type : types) {
            Map.Entry<Long, DbDataType<?>> entry;
            TreeMap<Long, DbDataType<?>> dic;
            if (type == null || (dic = this.dataLengthType.get((Object)type)) == null || (entry = dic.lastEntry()) == null) continue;
            return entry.getValue();
        }
        return null;
    }

    private DbDataType<?> getDbTypeLengthInternal(DataType type, Long columnSize) {
        if (this.dataLengthType.containsKey((Object)type)) {
            TreeMap<Long, DbDataType<?>> dic = this.dataLengthType.get((Object)type);
            DbDataType<?> last = null;
            if (dic.containsKey(columnSize)) {
                last = dic.get(columnSize);
                if (last.isDeprecated()) {
                    return last.getDeprecatedSurrogateType();
                }
                return last;
            }
            Map.Entry<Long, DbDataType<?>> entry = dic.ceilingEntry(columnSize);
            if (entry != null && entry.getKey() >= columnSize) {
                last = entry.getValue();
                if (last.isDeprecated()) {
                    return last.getDeprecatedSurrogateType();
                }
                return last;
            }
        }
        return null;
    }

    public DbDataType<?> match(String productDataType, Long length, DataTypeLengthProperties<?> column) {
        DbDataType<?> dbDataType;
        TreeMap<Long, DbDataType<?>> childMap;
        DbDataType<?> result;
        if (length == null) {
            if (this.noMatchProductDataTypeDbTypeCache.contains(productDataType)) {
                return null;
            }
            result = this.productDataTypeDbTypeCache.get(productDataType);
            if (result != null) {
                return result;
            }
            for (Map.Entry<DataType, TreeMap<Long, DbDataType<?>>> entry : this.dataLengthType.entrySet()) {
                childMap = entry.getValue();
                for (Map.Entry<Long, DbDataType<?>> childEntry : childMap.entrySet()) {
                    dbDataType = childEntry.getValue();
                    if (!dbDataType.parseAndSet(productDataType, column)) continue;
                    this.productDataTypeDbTypeCache.put(productDataType, dbDataType);
                    return dbDataType;
                }
            }
        } else {
            result = this.productDataLengthTypeDbTypeCache.get(productDataType, length);
            if (result != null) {
                return result;
            }
            block2: for (Map.Entry<DataType, TreeMap<Long, DbDataType<?>>> entry : this.dataLengthType.entrySet()) {
                childMap = entry.getValue();
                for (Map.Entry<Long, DbDataType<?>> childEntry : childMap.entrySet()) {
                    if (length == null || childEntry.getKey().compareTo(length) < 0) continue;
                    dbDataType = childEntry.getValue();
                    if (!dbDataType.parseAndSet(productDataType, column)) continue block2;
                    this.productDataLengthTypeDbTypeCache.put(productDataType, length, dbDataType);
                    this.productDataTypeDbTypeCache.put(productDataType, dbDataType);
                    return dbDataType;
                }
            }
        }
        for (Map.Entry<DataType, DbDataType<?>> entry : this.dataTypeMap.entrySet()) {
            DbDataType<?> dbDataType2 = entry.getValue();
            if (!dbDataType2.parseAndSet(productDataType, column)) continue;
            this.productDataTypeDbTypeCache.put(productDataType, dbDataType2);
            return dbDataType2;
        }
        this.noMatchProductDataTypeDbTypeCache.add(productDataType);
        return null;
    }

    public String getColumCreateDefinition(DbDataType<?> dbDataType) {
        return dbDataType.getCreateFormat();
    }

    protected void addDataLength(DbDataType<?> dbDataType, Long size) {
        TreeMap<Object, Object> sortDic = null;
        if (this.dataLengthType.containsKey((Object)dbDataType.getDataType())) {
            sortDic = this.dataLengthType.get((Object)dbDataType.getDataType());
        } else {
            sortDic = new TreeMap();
            dbDataType.setParent(this);
            this.dataLengthType.put(dbDataType.getDataType(), sortDic);
        }
        if (sortDic.containsKey(size)) {
            sortDic.remove(size);
        }
        dbDataType.setParent(this);
        boolean lowerSize = false;
        for (Map.Entry<Object, Object> entry : sortDic.entrySet()) {
            if (size.compareTo((Long)entry.getKey()) < 0) continue;
            lowerSize = true;
            break;
        }
        sortDic.put(size, dbDataType);
        if (lowerSize) {
            if (!this.dataTypeMap.containsKey((Object)dbDataType.getDataType())) {
                this.add(dbDataType);
            }
        } else {
            this.add(dbDataType);
        }
    }

    protected DbDataType<?> add(DbDataType<?> dbDataType) {
        if (this.dataTypeMap.containsKey((Object)dbDataType.getDataType())) {
            this.dataTypeMap.remove((Object)dbDataType.getDataType());
        }
        dbDataType.setParent(this);
        this.dataTypeMap.put(dbDataType.getDataType(), dbDataType);
        return dbDataType;
    }

    public ArrayType addArray() {
        ArrayType type = new ArrayType();
        this.add(type);
        return type;
    }

    public CharType addChar(long size) {
        CharType type = new CharType();
        type.setMaxLength(size);
        this.addDataLength(type, size);
        return type;
    }

    public NCharType addNChar(long size) {
        NCharType type = new NCharType();
        type.setMaxLength(size);
        this.addDataLength(type, size);
        return type;
    }

    public MCharType addMChar(long size) {
        MCharType type = new MCharType();
        type.setMaxLength(size);
        this.addDataLength(type, size);
        return type;
    }

    public NCharType addNChar(String dataTypeName, long size) {
        NCharType type = new NCharType(dataTypeName);
        type.setMaxLength(size);
        this.addDataLength(type, size);
        return type;
    }

    public VarcharType addVarchar(long size) {
        VarcharType type = new VarcharType();
        type.setMaxLength(size);
        this.addDataLength(type, size);
        return type;
    }

    public VarcharIgnorecaseType addVarcharIgnoreCase(long size) {
        VarcharIgnorecaseType type = new VarcharIgnorecaseType();
        type.setMaxLength(size);
        this.addDataLength(type, size);
        return type;
    }

    public AlphanumType addAlphanum(long size) {
        AlphanumType type = new AlphanumType();
        type.setMaxLength(size);
        this.addDataLength(type, size);
        return type;
    }

    public NVarcharType addNVarchar(long size) {
        NVarcharType type = new NVarcharType();
        type.setMaxLength(size);
        this.addDataLength(type, size);
        return type;
    }

    public MVarcharType addMVarchar(long size) {
        MVarcharType type = new MVarcharType();
        type.setMaxLength(size);
        this.addDataLength(type, size);
        return type;
    }

    public VarcharType addVarchar(String dataTypeName, long size) {
        VarcharType type = new VarcharType(dataTypeName);
        type.setMaxLength(size);
        this.addDataLength(type, size);
        return type;
    }

    public NVarcharType addNVarchar(String dataTypeName, long size) {
        NVarcharType type = new NVarcharType(dataTypeName);
        type.setMaxLength(size);
        this.addDataLength(type, size);
        return type;
    }

    public SearchableTextType addSearchableText(String dataTypeName, long size) {
        SearchableTextType type = new SearchableTextType(dataTypeName);
        type.setMaxLength(size);
        this.addDataLength(type, size);
        return type;
    }

    public SearchableShortTextType addSearchableShortText(String dataTypeName, long size) {
        SearchableShortTextType type = new SearchableShortTextType(dataTypeName);
        type.setMaxLength(size);
        this.addDataLength(type, size);
        return type;
    }

    public LongVarcharType addLongVarchar(long size) {
        LongVarcharType type = new LongVarcharType();
        type.setMaxLength(size);
        this.addDataLength(type, size);
        return type;
    }

    public LongVarcharType addLongVarchar(String dataTypeName, long size) {
        LongVarcharType type = new LongVarcharType(dataTypeName);
        type.setMaxLength(size);
        this.addDataLength(type, size);
        return type;
    }

    public LongNVarcharType addLongNVarchar(long size) {
        LongNVarcharType type = new LongNVarcharType();
        type.setMaxLength(size);
        this.addDataLength(type, size);
        return type;
    }

    public LongNVarcharType addLongNVarchar(String dataTypeName, long size) {
        LongNVarcharType type = new LongNVarcharType(dataTypeName);
        type.setMaxLength(size);
        this.addDataLength(type, size);
        return type;
    }

    public ClobType addClob(String dataTypeName, long size) {
        ClobType type = new ClobType(dataTypeName);
        type.setMaxLength(size);
        this.addDataLength(type, size);
        return type;
    }

    public ClobType addClob(long size) {
        ClobType type = new ClobType();
        type.setMaxLength(size);
        this.addDataLength(type, size);
        return type;
    }

    public NClobType addNClob(String dataTypeName, long size) {
        NClobType type = new NClobType(dataTypeName);
        type.setMaxLength(size);
        this.addDataLength(type, size);
        return type;
    }

    public LongNVarcharType addLongNVarchar(String dataTypeName, long size, String createFormat) {
        LongNVarcharType type = new LongNVarcharType(dataTypeName);
        type.setMaxLength(size);
        type.setCreateFormat(createFormat);
        this.addDataLength(type, size);
        return type;
    }

    public BinaryType addBinary(String dataTypeName, long size) {
        BinaryType type = new BinaryType(dataTypeName);
        type.setMaxLength(size);
        this.addDataLength(type, size);
        return type;
    }

    public BinaryType addBinary(long size) {
        BinaryType type = new BinaryType();
        type.setMaxLength(size);
        this.addDataLength(type, size);
        return type;
    }

    public VarBinaryType addVarBinary(String dataTypeName, long size) {
        VarBinaryType type = new VarBinaryType(dataTypeName);
        type.setMaxLength(size);
        this.addDataLength(type, size);
        return type;
    }

    public VarBinaryType addVarBinary(long size) {
        VarBinaryType type = new VarBinaryType();
        type.setMaxLength(size);
        this.addDataLength(type, size);
        return type;
    }

    public LongVarBinaryType addLongVarBinary(long size) {
        LongVarBinaryType type = new LongVarBinaryType();
        this.addDataLength(type, size);
        return type;
    }

    public LongVarBinaryType addLongVarBinary(String dataTypeName, long size) {
        LongVarBinaryType type = new LongVarBinaryType(dataTypeName);
        type.setMaxLength(size);
        this.addDataLength(type, size);
        return type;
    }

    public BlobType addBlob(long size) {
        BlobType type = new BlobType();
        type.setMaxLength(size);
        this.addDataLength(type, size);
        return type;
    }

    public BlobType addBlob(String dataTypeName, long size) {
        BlobType type = new BlobType(dataTypeName);
        type.setDefaultLength(size);
        type.setMaxLength(size);
        this.addDataLength(type, size);
        return type;
    }

    public BitType addBit(String dataTypeName, String createFormat) {
        BitType type = new BitType(dataTypeName);
        type.setCreateFormat(createFormat);
        this.add(type);
        return type;
    }

    public BitType addBit(String dataTypeName) {
        BitType type = new BitType(dataTypeName);
        this.add(type);
        return type;
    }

    public BitType addBit() {
        BitType type = new BitType();
        this.add(type);
        return type;
    }

    public BooleanType addBoolean() {
        BooleanType type = new BooleanType();
        this.add(type);
        return type;
    }

    public BooleanType addBoolean(String dataTypeName) {
        BooleanType type = new BooleanType(dataTypeName);
        this.add(type);
        return type;
    }

    public BooleanType addBoolean(String dataTypeName, String createFormat, String defaultValueLiteral) {
        BooleanType type = new BooleanType(dataTypeName);
        type.setDefaultValueLiteral(defaultValueLiteral);
        this.add(type);
        return type;
    }

    public TinyIntType addTinyInt() {
        TinyIntType type = new TinyIntType();
        this.add(type);
        return type;
    }

    public TinyIntType addTinyInt(String dataTypeName) {
        TinyIntType type = new TinyIntType(dataTypeName);
        this.add(type);
        return type;
    }

    public SmallIntType addSmallInt() {
        SmallIntType type = new SmallIntType();
        this.add(type);
        return type;
    }

    public SmallIntType addSmallInt(String dataTypeName) {
        SmallIntType type = new SmallIntType(dataTypeName);
        this.add(type);
        return type;
    }

    public MediumIntType addMediumInt() {
        MediumIntType type = new MediumIntType();
        this.add(type);
        return type;
    }

    public MediumIntType addMediumInt(String dataTypeName) {
        MediumIntType type = new MediumIntType(dataTypeName);
        this.add(type);
        return type;
    }

    public IntType addInt() {
        IntType type = new IntType();
        this.add(type);
        return type;
    }

    public IntType addInt(String dataTypeName) {
        IntType type = new IntType(dataTypeName);
        this.add(type);
        return type;
    }

    public BigIntType addBigInt() {
        BigIntType type = new BigIntType();
        this.add(type);
        return type;
    }

    public BigIntType addBigInt(String dataTypeName) {
        BigIntType type = new BigIntType(dataTypeName);
        this.add(type);
        return type;
    }

    public HugeIntType addHugeIntType() {
        HugeIntType type = new HugeIntType();
        this.add(type);
        return type;
    }

    public HugeIntType addHugeIntType(String dataTypeName) {
        HugeIntType type = new HugeIntType(dataTypeName);
        this.add(type);
        return type;
    }

    public SmallSerialType addSmallSerial() {
        SmallSerialType type = new SmallSerialType();
        this.add(type);
        return type;
    }

    public SmallSerialType addSmallSerial(String dataTypeName) {
        SmallSerialType type = new SmallSerialType(dataTypeName);
        this.add(type);
        return type;
    }

    public SerialType addSerial() {
        SerialType type = new SerialType();
        this.add(type);
        return type;
    }

    public SerialType addSerial(String dataTypeName) {
        SerialType type = new SerialType(dataTypeName);
        this.add(type);
        return type;
    }

    public BigSerialType addBigSerial() {
        BigSerialType type = new BigSerialType();
        this.add(type);
        return type;
    }

    public BigSerialType addBigSerial(String dataTypeName) {
        BigSerialType type = new BigSerialType(dataTypeName);
        this.add(type);
        return type;
    }

    public UTinyIntType addUTinyInt() {
        UTinyIntType type = new UTinyIntType();
        this.add(type);
        return type;
    }

    public UTinyIntType addUTinyInt(String dataTypeName) {
        UTinyIntType type = new UTinyIntType(dataTypeName);
        this.add(type);
        return type;
    }

    public USmallIntType addUSmallInt() {
        USmallIntType type = new USmallIntType();
        this.add(type);
        return type;
    }

    public USmallIntType addUSmallInt(String dataTypeName) {
        USmallIntType type = new USmallIntType(dataTypeName);
        this.add(type);
        return type;
    }

    public UMediumIntType addUMediumInt() {
        UMediumIntType type = new UMediumIntType();
        this.add(type);
        return type;
    }

    public UIntType addUInt() {
        UIntType type = new UIntType();
        this.add(type);
        return type;
    }

    public UIntType addUInt(String dataTypeName) {
        UIntType type = new UIntType(dataTypeName);
        this.add(type);
        return type;
    }

    public UBigIntType addUBigInt() {
        UBigIntType type = new UBigIntType();
        this.add(type);
        return type;
    }

    public UBigIntType addUBigInt(String dataTypeName) {
        UBigIntType type = new UBigIntType(dataTypeName);
        this.add(type);
        return type;
    }

    public UUIDType addUUID() {
        UUIDType type = new UUIDType();
        this.add(type);
        return type;
    }

    public UUIDType addUUID(String dataTypeName) {
        UUIDType type = new UUIDType(dataTypeName);
        this.add(type);
        return type;
    }

    public SqlXmlType addSqlXml(String dataTypeName) {
        SqlXmlType type = new SqlXmlType(dataTypeName);
        this.add(type);
        return type;
    }

    public SqlXmlType addSqlXml(String dataTypeName, long size) {
        SqlXmlType type = new SqlXmlType(dataTypeName);
        type.setMaxLength(size);
        this.addDataLength(type, size);
        return type;
    }

    public RealType addReal() {
        RealType type = new RealType();
        this.add(type);
        return type;
    }

    public RealType addReal(String dataTypeName) {
        RealType type = new RealType(dataTypeName);
        this.add(type);
        return type;
    }

    public DoubleType addDouble() {
        DoubleType type = new DoubleType();
        this.add(type);
        return type;
    }

    public DoubleType addDouble(String dataTypeName) {
        DoubleType type = new DoubleType(dataTypeName);
        this.add(type);
        return type;
    }

    public FloatType addFloat(long size) {
        FloatType type = new FloatType();
        this.addDataLength(type, size);
        return type;
    }

    public DecimalFloatType addDecimalFloat(long size) {
        DecimalFloatType type = new DecimalFloatType();
        this.addDataLength(type, size);
        return type;
    }

    public DecimalFloatType addDecimalFloat(String dataTypeName) {
        DecimalFloatType type = new DecimalFloatType(dataTypeName);
        return type;
    }

    public DateType addDate() {
        DateType type = new DateType();
        this.add(type);
        return type;
    }

    public SmallDateTimeType addSmallDateTime(String dataTypeName) {
        SmallDateTimeType type = new SmallDateTimeType(dataTypeName);
        this.add(type);
        return type;
    }

    public SmallDateTimeType addSmallDateTime() {
        SmallDateTimeType type = new SmallDateTimeType();
        this.add(type);
        return type;
    }

    public DateTimeType addDateTime() {
        DateTimeType type = new DateTimeType();
        this.add(type);
        return type;
    }

    public DateTimeType addDateTime(String dataTypeName) {
        DateTimeType type = new DateTimeType(dataTypeName);
        this.add(type);
        return type;
    }

    public TimeType addTime() {
        TimeType type = new TimeType();
        this.add(type);
        return type;
    }

    public TimeType addTime(String dataTypeName) {
        TimeType type = new TimeType(dataTypeName);
        this.add(type);
        return type;
    }

    public TimeWithTimeZoneType addTimeWithTimeZone() {
        TimeWithTimeZoneType type = new TimeWithTimeZoneType();
        this.add(type);
        return type;
    }

    public TimeWithTimeZoneType addTimeWithTimeZone(String dataTypeName) {
        TimeWithTimeZoneType type = new TimeWithTimeZoneType(dataTypeName);
        this.add(type);
        return type;
    }

    public TimestampType addTimestamp() {
        TimestampType type = new TimestampType();
        this.add(type);
        return type;
    }

    public TimestampType addTimestamp(String dataTypeName) {
        TimestampType type = new TimestampType(dataTypeName);
        this.add(type);
        return type;
    }

    public TimestampVersionType addTimestampVersion(String dataTypeName) {
        TimestampVersionType type = new TimestampVersionType(dataTypeName);
        this.add(type);
        return type;
    }

    public TimestampVersionType addTimestampVersion() {
        TimestampVersionType type = new TimestampVersionType();
        this.add(type);
        return type;
    }

    public TimestampWithTimeZoneType addTimestampWithTimeZoneType() {
        TimestampWithTimeZoneType type = new TimestampWithTimeZoneType();
        this.add(type);
        return type;
    }

    public TimestampWithTimeZoneType addTimestampWithTimeZoneType(String dataTypeName) {
        TimestampWithTimeZoneType type = new TimestampWithTimeZoneType(dataTypeName);
        this.add(type);
        return type;
    }

    public RowVersionType addRowVersion(String dataTypeName) {
        RowVersionType type = new RowVersionType(dataTypeName);
        this.add(type);
        return type;
    }

    public RowVersionType addRowVersion() {
        RowVersionType type = new RowVersionType();
        this.add(type);
        return type;
    }

    public DecimalType addDecimal() {
        DecimalType type = new DecimalType();
        this.add(type);
        return type;
    }

    public DecimalType addDecimal(String dataTypeName) {
        DecimalType type = new DecimalType(dataTypeName);
        this.add(type);
        return type;
    }

    public NumericType addNumeric() {
        NumericType type = new NumericType();
        this.add(type);
        return type;
    }

    public NumericType addNumeric(String dataTypeName) {
        NumericType type = new NumericType(dataTypeName);
        this.add(type);
        return type;
    }

    public SmallMoneyType addSmallMoney(String dataTypeName) {
        SmallMoneyType type = new SmallMoneyType(dataTypeName);
        this.add(type);
        return type;
    }

    public MoneyType addMoney(String dataTypeName) {
        MoneyType type = new MoneyType(dataTypeName);
        this.add(type);
        return type;
    }

    public DataLinkType addDataLinkType(String dataTypeName) {
        DataLinkType type = new DataLinkType(dataTypeName);
        this.add(type);
        return type;
    }

    public InetType addInetType() {
        InetType type = new InetType();
        this.add(type);
        return type;
    }

    public CidrType addCidrType() {
        CidrType type = new CidrType();
        this.add(type);
        return type;
    }

    public MacAddrType addMacAddrType() {
        MacAddrType type = new MacAddrType();
        this.add(type);
        return type;
    }

    public IntervalType addInterval() {
        IntervalType type = new IntervalType();
        this.add(type);
        return type;
    }

    public IntervalYearType addIntervalYear() {
        IntervalYearType type = new IntervalYearType();
        this.add(type);
        return type;
    }

    public IntervalMonthType addIntervalMonth() {
        IntervalMonthType type = new IntervalMonthType();
        this.add(type);
        return type;
    }

    public IntervalDayType addIntervalDay() {
        IntervalDayType type = new IntervalDayType();
        this.add(type);
        return type;
    }

    public IntervalHourType addIntervalHour() {
        IntervalHourType type = new IntervalHourType();
        this.add(type);
        return type;
    }

    public IntervalMinuteType addIntervalMinute() {
        IntervalMinuteType type = new IntervalMinuteType();
        this.add(type);
        return type;
    }

    public IntervalSecondType addIntervalSecond() {
        IntervalSecondType type = new IntervalSecondType();
        this.add(type);
        return type;
    }

    public IntervalYearToMonthType addIntervalYearToMonth() {
        IntervalYearToMonthType type = new IntervalYearToMonthType();
        this.add(type);
        return type;
    }

    public IntervalYearToDayType addIntervalYearToDay() {
        IntervalYearToDayType type = new IntervalYearToDayType();
        this.add(type);
        return type;
    }

    public IntervalDayToHourType addIntervalDayToHour() {
        IntervalDayToHourType type = new IntervalDayToHourType();
        this.add(type);
        return type;
    }

    public IntervalDayToMinuteType addIntervalDayToMinute() {
        IntervalDayToMinuteType type = new IntervalDayToMinuteType();
        this.add(type);
        return type;
    }

    public IntervalDayToSecondType addIntervalDayToSecond() {
        IntervalDayToSecondType type = new IntervalDayToSecondType();
        this.add(type);
        return type;
    }

    public IntervalHourToMinuteType addIntervalHourToMinute() {
        IntervalHourToMinuteType type = new IntervalHourToMinuteType();
        this.add(type);
        return type;
    }

    public IntervalHourToSecondType addIntervalHourToSecond() {
        IntervalHourToSecondType type = new IntervalHourToSecondType();
        this.add(type);
        return type;
    }

    public IntervalMinuteToSecondType addIntervalMinuteToSecond() {
        IntervalMinuteToSecondType type = new IntervalMinuteToSecondType();
        this.add(type);
        return type;
    }

    public GeometryType addGeometry() {
        GeometryType type = new GeometryType();
        this.add(type);
        return type;
    }

    public GeometryType addGeometry(String dataTypeName) {
        GeometryType type = new GeometryType(dataTypeName);
        this.add(type);
        return type;
    }

    public GeographyType addGeography() {
        GeographyType type = new GeographyType();
        this.add(type);
        return type;
    }

    public EnumType addEnum() {
        EnumType type = new EnumType();
        this.add(type);
        return type;
    }

    public SetType addSet() {
        SetType type = new SetType();
        this.add(type);
        return type;
    }

    public YesOrNoType addYesOrNo() {
        YesOrNoType type = new YesOrNoType();
        this.add(type);
        return type;
    }

    public RowIdType addRowId() {
        RowIdType type = new RowIdType();
        this.add(type);
        return type;
    }

    public RowIdType addRowId(String dataTypeName) {
        RowIdType type = new RowIdType(dataTypeName);
        this.add(type);
        return type;
    }

    public AnyDataType addAnyData() {
        AnyDataType type = new AnyDataType();
        this.add(type);
        return type;
    }

    public AnyDataType addAnyData(String dataTypeName) {
        AnyDataType type = new AnyDataType(dataTypeName);
        this.add(type);
        return type;
    }

    public SqlIdentifierType addSqlIdentifierType(String dataTypeName) {
        SqlIdentifierType type = new SqlIdentifierType(dataTypeName);
        this.add(type);
        return type;
    }

    public SqlIdentifierType addSqlIdentifierType() {
        SqlIdentifierType type = new SqlIdentifierType();
        this.add(type);
        return type;
    }

    public PointType addPointType() {
        PointType type = new PointType();
        this.add(type);
        return type;
    }

    public CircleType addCircleType() {
        CircleType type = new CircleType();
        this.add(type);
        return type;
    }

    public LineType addLineType() {
        LineType type = new LineType();
        this.add(type);
        return type;
    }

    public BoxType addBoxType() {
        BoxType type = new BoxType();
        this.add(type);
        return type;
    }

    public LsegType addLsegType() {
        LsegType type = new LsegType();
        this.add(type);
        return type;
    }

    public PathType addPathType() {
        PathType type = new PathType();
        this.add(type);
        return type;
    }

    public PolygonType addPolygonType() {
        PolygonType type = new PolygonType();
        this.add(type);
        return type;
    }

    public JsonType addJsonType() {
        JsonType type = new JsonType();
        this.add(type);
        return type;
    }

    public JsonbType addJsonbType() {
        JsonbType type = new JsonbType();
        this.add(type);
        return type;
    }

    protected Map<DataType, DataType> getSurrogateMap() {
        return this.surrogateMap;
    }

    static class ArrayDimensionHandler
    implements BiConsumer<Matcher, ArrayDimensionProperties<?>> {
        ArrayDimensionHandler() {
        }

        @Override
        public void accept(Matcher matcher, ArrayDimensionProperties<?> column) {
            String val = matcher.group(matcher.groupCount());
            Integer intVal = CommonUtils.toInteger(val);
            if (intVal != null) {
                column.setArrayDimension(1);
                column.setArrayDimensionUpperBound(intVal);
            }
        }
    }

    static class ArrayPatternGenerator
    implements Function<String, String> {
        ArrayPatternGenerator() {
        }

        @Override
        public String apply(String t) {
            return "(?<dataTypeName>" + CommonUtils.trim(t) + ")\\s*ARRAY\\\\s*\\\\[\\\\s*([0-9]+){0,1}\\\\s*\\\\]";
        }
    }
}

