/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.datatype;

import com.sqlapp.data.converter.Converter;
import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.converter.DefaultConverter;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.datatype.JdbcTypeHandler;
import java.io.Serializable;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DefaultJdbcTypeHandler
implements Serializable,
JdbcTypeHandler {
    private static final long serialVersionUID = 7620601581332242273L;
    protected JDBCType jdbcType = JDBCType.VARCHAR;
    protected Converter statementConverter = new DefaultConverter();
    protected Converter resultSetconverter = new DefaultConverter();

    public DefaultJdbcTypeHandler(DataType types) {
        this.jdbcType = types.getJdbcType();
        if (types.getDefaultClass() != null) {
            Object converter = Converters.getDefault().getConverter(types.getDefaultClass());
            this.statementConverter = converter;
            this.resultSetconverter = converter;
        }
    }

    public DefaultJdbcTypeHandler(JDBCType jdbcType) {
        this.jdbcType = jdbcType;
    }

    public DefaultJdbcTypeHandler(JDBCType jdbcType, Converter<?> converter) {
        this.jdbcType = jdbcType;
        this.statementConverter = converter;
        this.resultSetconverter = converter;
    }

    public DefaultJdbcTypeHandler(JDBCType jdbcType, Converter<?> statementConverter, Converter<?> resultSetconverter) {
        this.jdbcType = jdbcType;
        this.statementConverter = statementConverter;
        this.resultSetconverter = resultSetconverter;
    }

    @Override
    public Object getObject(ResultSet rs, int columnIndex) throws SQLException {
        return this.resultSetconverter.convertObject(rs.getObject(columnIndex));
    }

    @Override
    public Object getObject(ResultSet rs, String columnLabel) throws SQLException {
        return this.resultSetconverter.convertObject(rs.getObject(columnLabel));
    }

    @Override
    public void setObject(PreparedStatement stmt, int parameterIndex, Object x) throws SQLException {
        if (x == null) {
            stmt.setNull(parameterIndex, this.jdbcType.getVendorTypeNumber());
        } else {
            stmt.setObject(parameterIndex, this.statementConverter.convertObject(x, stmt.getConnection()), this.jdbcType);
        }
    }

    public DefaultJdbcTypeHandler setStatementConverter(Converter<?> statementConverter) {
        this.statementConverter = statementConverter;
        return this;
    }

    public DefaultJdbcTypeHandler setResultSetconverter(Converter<?> resultSetconverter) {
        this.resultSetconverter = resultSetconverter;
        return this;
    }

    public DefaultJdbcTypeHandler setJdbcType(JDBCType jdbcType) {
        this.jdbcType = jdbcType;
        return this;
    }
}

