/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.information_schema.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.ObjectPrivilegeReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ObjectPrivilege;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class ISObjectPrivilegeReader
extends ObjectPrivilegeReader {
    protected ISObjectPrivilegeReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected List<ObjectPrivilege> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNode(productVersionInfo);
        final List<ObjectPrivilege> result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            @Override
            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                ObjectPrivilege obj = ISObjectPrivilegeReader.this.createPrivilege(rs);
                result.add(obj);
            }
        });
        return result;
    }

    protected ObjectPrivilege createPrivilege(ExResultSet rs) throws SQLException {
        ObjectPrivilege obj = new ObjectPrivilege();
        obj.setCatalogName(this.getString(rs, "TABLE_CATALOG"));
        obj.setSchemaName(this.getString(rs, "TABLE_SCHEMA"));
        obj.setObjectName(this.getString(rs, "table_name"));
        obj.setGrantorName(this.getString(rs, "grantor"));
        obj.setGranteeName(this.getString(rs, "grantee"));
        obj.setPrivilege(this.getString(rs, "privilege_type"));
        obj.setGrantable("YES".equals(this.getString(rs, "IS_GRANTABLE")));
        return obj;
    }

    protected SqlNode getSqlNode(ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNodeCache(ISObjectPrivilegeReader.class).getString("objectPrivileges.sql");
        return node;
    }
}

