/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.jdbc.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.ObjectPrivilegeReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ObjectPrivilege;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DbUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class JdbcObjectPrivilegeReader
extends ObjectPrivilegeReader {
    public JdbcObjectPrivilegeReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected List<ObjectPrivilege> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        List<ObjectPrivilege> list;
        ResultSet rs = null;
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            rs = databaseMetaData.getTablePrivileges(CommonUtils.coalesce(CommonUtils.emptyToNull(this.getCatalogName(context)), CommonUtils.emptyToNull(this.getCatalogName())), CommonUtils.coalesce(CommonUtils.emptyToNull(this.getSchemaName(context)), CommonUtils.emptyToNull(this.getSchemaName())), CommonUtils.coalesce(CommonUtils.emptyToNull(this.getObjectName(context)), CommonUtils.emptyToNull(this.getObjectName())));
            List<ObjectPrivilege> result = CommonUtils.list();
            while (rs.next()) {
                ObjectPrivilege columnPrivilege = this.createPrivilege(rs);
                result.add(columnPrivilege);
            }
            list = result;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DbUtils.close(rs);
                throw throwable;
            }
        }
        DbUtils.close(rs);
        return list;
    }

    protected ObjectPrivilege createPrivilege(ResultSet rs) throws SQLException {
        String catalogName = this.getString(rs, "TABLE_CAT");
        String schemaName = this.getString(rs, "TABLE_SCHEM");
        String objectName = this.getString(rs, "table_name");
        ObjectPrivilege obj = new ObjectPrivilege();
        obj.setCatalogName(catalogName);
        obj.setSchemaName(schemaName);
        obj.setObjectName(objectName);
        obj.setGrantorName(this.getString(rs, "grantor"));
        obj.setGranteeName(this.getString(rs, "grantee"));
        obj.setPrivilege(this.getString(rs, "PRIVILEGE"));
        obj.setGrantable("YES".equals(this.getString(rs, "IS_GRANTABLE")));
        return obj;
    }
}

