/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.jdbc.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.UniqueConstraintReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.UniqueConstraint;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DbUtils;
import com.sqlapp.util.FlexList;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class JdbcPrimaryKeyConstraintReader
extends UniqueConstraintReader {
    public JdbcPrimaryKeyConstraintReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected List<UniqueConstraint> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        List<UniqueConstraint> list;
        ResultSet rs = null;
        List<UniqueConstraint> list2 = CommonUtils.list();
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            rs = databaseMetaData.getPrimaryKeys(CommonUtils.coalesce(CommonUtils.emptyToNull(this.getCatalogName(context)), CommonUtils.emptyToNull(this.getCatalogName())), CommonUtils.coalesce(CommonUtils.emptyToNull(this.getSchemaName(context)), CommonUtils.emptyToNull(this.getSchemaName())), CommonUtils.coalesce(CommonUtils.emptyToNull(this.getObjectName(context)), CommonUtils.emptyToNull(this.getObjectName())));
            TripleKeyMap<String, String, String, UniqueConstraint> tUkMap = CommonUtils.tripleKeyMap();
            TripleKeyMap tColMap = CommonUtils.tripleKeyMap();
            while (rs.next()) {
                String table_catalog = this.getString(rs, "TABLE_CAT");
                String table_schema = this.getString(rs, "TABLE_SCHEM");
                String table_name = this.getString(rs, "table_name");
                String columnName = this.getString(rs, "column_name");
                String pk_name = this.getString(rs, "PK_NAME");
                int keySeq = rs.getInt("KEY_SEQ");
                UniqueConstraint uk = (UniqueConstraint)tUkMap.get(table_catalog, table_schema, table_name);
                FlexList<String> colList = (FlexList<String>)tColMap.get(table_catalog, table_schema, table_name);
                if (uk == null) {
                    uk = new UniqueConstraint(pk_name);
                    uk.setCatalogName(table_catalog);
                    uk.setSchemaName(table_schema);
                    uk.setTableName(table_schema);
                    colList = new FlexList<String>();
                    tUkMap.put(table_catalog, table_schema, table_name, uk);
                    tColMap.put(table_catalog, table_schema, table_name, colList);
                    list2.add(uk);
                }
                colList.add(keySeq, columnName);
            }
            for (UniqueConstraint uk : list2) {
                FlexList colList = (FlexList)tColMap.get(uk.getCatalogName(), uk.getSchemaName(), uk.getTableName());
                uk.getColumns().add(colList.toArray(new String[0]));
            }
            list = list2;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DbUtils.close(rs);
                throw throwable;
            }
        }
        DbUtils.close(rs);
        return list;
    }
}

