/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.standard.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.ColumnReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DbUtils;
import com.sqlapp.util.SqlBuilder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.regex.Pattern;

public class ResultSetColumnReader
extends ColumnReader {
    public ResultSetColumnReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    public List<Column> getAllFull(Connection connection) {
        PreparedStatement ps = null;
        ExResultSet rs = null;
        List<Column> result = null;
        try {
            String sql = this.getMetadataSql(this.getCatalogName(), this.getSchemaName(), this.getObjectName());
            ps = connection.prepareStatement(sql);
            rs = new ExResultSet(ps.executeQuery());
            result = this.getColumnMetadata(rs, this.getColumnName());
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DbUtils.close(rs);
                DbUtils.close(ps);
                throw throwable;
            }
        }
        DbUtils.close(rs);
        DbUtils.close(ps);
        return result;
    }

    private String getMetadataSql(String catalogName, String schemaName, String objectName) {
        SqlBuilder sql = new SqlBuilder(this.getDialect());
        ((SqlBuilder)sql.select()).lineBreak(" *");
        ((SqlBuilder)((SqlBuilder)sql.from()).space())._add(this.getDialect().getObjectFullName(catalogName, schemaName, objectName));
        ((SqlBuilder)sql.where())._add(" 1=0");
        return sql.toString();
    }

    protected List<Column> getColumnMetadata(ResultSet rs, String columnName) throws SQLException {
        Pattern pattern = null;
        if (!CommonUtils.isEmpty(columnName)) {
            pattern = Pattern.compile(columnName.replaceAll("[%]", ".*"), 2);
        }
        ResultSetMetaData metaData = rs.getMetaData();
        int colCount = metaData.getColumnCount();
        List<Column> result = CommonUtils.list(colCount);
        for (int i = 1; i <= colCount; ++i) {
            String colName = metaData.getColumnName(i);
            int sqlType = metaData.getColumnType(i);
            String productDataType = metaData.getColumnTypeName(i);
            long precision = metaData.getPrecision(i);
            int nullable = metaData.isNullable(i);
            int scale = metaData.getScale(i);
            boolean allowDBNull = false;
            if (nullable != 2 && nullable == 1) {
                allowDBNull = true;
            }
            boolean autoIncrement = metaData.isAutoIncrement(i);
            Column column = new Column(colName);
            this.getDialect().setDbType(sqlType, productDataType, (Long)precision, (Integer)scale, column);
            column.setNotNull(!allowDBNull);
            column.setIdentity(autoIncrement);
            if (pattern == null) {
                result.add(column);
                continue;
            }
            if (!pattern.matcher(colName).matches()) continue;
            result.add(column);
        }
        return result;
    }

    @Override
    protected List<Column> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        PreparedStatement ps = null;
        ExResultSet rs = null;
        List<Column> result = null;
        try {
            ps = connection.prepareStatement(this.getMetadataSql(this.getCatalogName(context), this.getSchemaName(context), this.getObjectName()));
            rs = new ExResultSet(ps.executeQuery());
            result = this.getColumnMetadata(rs, this.getColumnName());
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DbUtils.close(rs);
                DbUtils.close(ps);
                throw throwable;
            }
        }
        DbUtils.close(rs);
        DbUtils.close(ps);
        return result;
    }
}

