/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.ColumnPair;
import com.sqlapp.data.db.metadata.ConstraintReader;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ForeignKeyConstraint;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FlexList;
import com.sqlapp.util.TripleKeyMap;
import java.util.List;

public abstract class ForeignKeyConstraintReader
extends ConstraintReader<ForeignKeyConstraint> {
    protected ForeignKeyConstraintReader(Dialect dialect) {
        super(dialect);
    }

    protected void setForeignKeyConstraintColumns(TripleKeyMap<String, String, String, FlexList<ColumnPair>> tColMap, List<ForeignKeyConstraint> list) {
        for (ForeignKeyConstraint c : list) {
            FlexList<ColumnPair> colList = tColMap.get(c.getCatalogName(), c.getSchemaName(), c.getName());
            ColumnPair cPair = CommonUtils.first(colList);
            Table rTable = new Table(cPair.refTableName);
            rTable.setCatalogName(cPair.refCatalogName);
            rTable.setSchemaName(cPair.refSchemaName);
            Column[] columns = new Column[colList.size()];
            Column[] rColumns = new Column[colList.size()];
            for (int i = 0; i < columns.length; ++i) {
                cPair = colList.get(i);
                columns[i] = this.createColumn(c.getCatalogName(), c.getSchemaName(), c.getTableName(), cPair.columnName);
                rColumns[i] = this.createColumn(cPair.refCatalogName, cPair.refSchemaName, cPair.refTableName, cPair.refColumnName);
            }
            c.setColumns(columns);
            c.setRelatedColumns(rColumns);
        }
    }

    protected Column createColumn(String catalogName, String schemaName, String tableName, String columnName) {
        Column column = new Column(columnName);
        column.setCatalogName(catalogName);
        column.setSchemaName(schemaName);
        column.setTableName(tableName);
        return column;
    }
}

