/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.AbstractSchemaObjectReader;
import com.sqlapp.data.db.metadata.MviewLogColumnReader;
import com.sqlapp.data.db.metadata.TableObjectReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.DbObjects;
import com.sqlapp.data.schemas.MviewLog;
import com.sqlapp.data.schemas.ReferenceColumn;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.util.List;

public abstract class MviewLogReader
extends AbstractSchemaObjectReader<MviewLog> {
    protected MviewLogReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected SchemaObjectProperties getSchemaObjectProperties() {
        return SchemaObjectProperties.MVIEW_LOGS;
    }

    @Override
    protected String getNameLabel() {
        return DbObjects.MVIEW_LOG.getCamelCaseNameLabel();
    }

    protected <T extends AbstractSchemaObject<? super T>> TripleKeyMap<String, String, String, List<T>> getTableObjectKeyMap(Connection connection, TableObjectReader<T> reader) {
        if (reader == null) {
            return new TripleKeyMap<String, String, String, List<T>>();
        }
        List ccList = reader.getAllFull(connection);
        TripleKeyMap<String, String, String, List<T>> ccMap = reader.toKeyMap(ccList);
        return ccMap;
    }

    @Override
    public List<MviewLog> getAllFull(Connection connection) {
        ParametersContext context = this.defaultParametersContext(connection);
        List<MviewLog> tableList = this.getAll(connection, context);
        this.loadAllMetadata(connection, tableList);
        return tableList;
    }

    protected void loadAllMetadata(Connection connection, List<MviewLog> mviewLogList) {
        TripleKeyMap<String, String, String, List<ReferenceColumn>> columnMap = this.getTableObjectKeyMap(connection, this.getMviewLogColumnReader());
        for (MviewLog mviewLog : mviewLogList) {
            mviewLog.setDialect(this.getDialect());
            List<ReferenceColumn> columns = columnMap.get(mviewLog.getCatalogName(), mviewLog.getSchemaName(), mviewLog.getMasterTableName());
            if (CommonUtils.isEmpty(columns)) continue;
            mviewLog.getColumns().addAll(columns);
            columnMap.remove(mviewLog.getCatalogName(), mviewLog.getSchemaName(), mviewLog.getMasterTableName());
        }
    }

    protected TripleKeyMap<String, String, String, List<ReferenceColumn>> getTableObjectKeyMap(Connection connection, MviewLogColumnReader reader) {
        if (reader == null) {
            return new TripleKeyMap<String, String, String, List<ReferenceColumn>>();
        }
        List<ReferenceColumn> ccList = reader.getAllFull(connection);
        TripleKeyMap<String, String, String, List<ReferenceColumn>> ccMap = reader.toKeyMap(ccList);
        return ccMap;
    }

    protected void setTableObjects(Connection connection, TableObjectReader<?> reader, Table table) {
        if (reader != null) {
            reader.loadFull(connection, table);
        }
    }

    protected MviewLogColumnReader getMviewLogColumnReader() {
        MviewLogColumnReader reader = this.newMviewLogColumnReader();
        this.setObjectName(reader);
        return reader;
    }

    protected abstract MviewLogColumnReader newMviewLogColumnReader();

    protected void setObjectName(MviewLogColumnReader reader) {
        if (reader != null) {
            reader.setCatalogName(this.getCatalogName());
            reader.setSchemaName(this.getSchemaName());
            reader.setObjectName(this.getObjectName());
            this.initializeChild(reader);
        }
    }
}

