/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.metadata;

import com.sqlapp.data.db.metadata.MetadataReader;
import com.sqlapp.data.db.metadata.ReadDbObjectPredicate;
import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.DbObject;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaObjectNameHolder;
import com.sqlapp.data.schemas.properties.CatalogNameProperty;
import com.sqlapp.data.schemas.properties.NameProperty;
import com.sqlapp.data.schemas.properties.SchemaNameProperty;
import com.sqlapp.data.schemas.properties.SpecificNameProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DoubleKeyMap;
import com.sqlapp.util.ToStringBuilder;
import java.util.List;

public class ObjectNameReaderPredicate
implements ReadDbObjectPredicate {
    private String[] includeSchemas = null;
    private String[] excludeSchemas = null;
    private String[] includes = null;
    private String[] excludes = null;
    private DoubleKeyMap<String, String, SchemaNameHolder> includeSchemaMap = CommonUtils.doubleKeyMap();
    private DoubleKeyMap<String, String, SchemaNameHolder> excludeSchemaMap = CommonUtils.doubleKeyMap();
    private List<SchemaObjectNameHolder> includeList = CommonUtils.list();
    private List<SchemaObjectNameHolder> excludeList = CommonUtils.list();

    public ObjectNameReaderPredicate(String[] includeSchemas, String[] excludeSchemas, String[] includes, String[] excludes) {
        this.includeSchemas = includeSchemas;
        this.excludeSchemas = excludeSchemas;
        this.includes = includes;
        this.excludes = excludes;
        this.initialize(includeSchemas, excludeSchemas, includes, excludes);
    }

    protected void initialize(String[] includeSchemas, String[] excludeSchemas, String[] includes, String[] excludes) {
        Object nameHolder;
        if (includeSchemas != null) {
            for (String arg : includeSchemas) {
                nameHolder = new SchemaNameHolder(arg);
                this.includeSchemaMap.put(((SchemaNameHolder)nameHolder).catalogName, ((SchemaNameHolder)nameHolder).schemaName, (SchemaNameHolder)nameHolder);
            }
        }
        if (excludeSchemas != null) {
            for (String arg : excludeSchemas) {
                nameHolder = new SchemaNameHolder(arg);
                this.excludeSchemaMap.put(((SchemaNameHolder)nameHolder).catalogName, ((SchemaNameHolder)nameHolder).schemaName, (SchemaNameHolder)nameHolder);
            }
        }
        if (includes != null) {
            this.includeList.clear();
            for (String arg : includes) {
                nameHolder = new SchemaObjectNameHolder(arg);
                this.includeList.add((SchemaObjectNameHolder)nameHolder);
            }
        }
        if (excludes != null) {
            this.excludeList.clear();
            for (String arg : excludes) {
                nameHolder = new SchemaObjectNameHolder(arg);
                this.excludeList.add((SchemaObjectNameHolder)nameHolder);
            }
        }
    }

    @Override
    public boolean test(DbObject<?> dbObject, MetadataReader<?, ?> reader) {
        Object nameProperty;
        String catalogName = null;
        String schemaName = null;
        String specificName = null;
        String name = null;
        if (!(dbObject instanceof AbstractNamedObject)) {
            return true;
        }
        if (dbObject instanceof Schema) {
            return this.match((Schema)dbObject);
        }
        if (dbObject instanceof CatalogNameProperty) {
            nameProperty = (CatalogNameProperty)((Object)dbObject);
            catalogName = nameProperty.getCatalogName();
        }
        if (dbObject instanceof SchemaNameProperty) {
            nameProperty = (SchemaNameProperty)((Object)dbObject);
            schemaName = nameProperty.getSchemaName();
        }
        if (dbObject instanceof SpecificNameProperty) {
            nameProperty = (SpecificNameProperty)((Object)dbObject);
            specificName = nameProperty.getSpecificName();
        }
        if (dbObject instanceof NameProperty) {
            nameProperty = (NameProperty)((Object)dbObject);
            name = nameProperty.getName();
        }
        return this.match(catalogName, schemaName, specificName, name);
    }

    private boolean match(Schema schema) {
        Object catalogName = null;
        String schemaName = schema.getName();
        SchemaNameHolder nameHolder = this.excludeSchemaMap.get((String)catalogName, schemaName);
        if (nameHolder != null) {
            return false;
        }
        if (this.includeSchemaMap.size() == 0) {
            return true;
        }
        nameHolder = this.includeSchemaMap.get((String)catalogName, schemaName);
        return nameHolder != null;
    }

    private boolean match(String catalogName, String schemaName, String specificName, String name) {
        if (this.excludeList.size() > 0) {
            if (this.find(catalogName, schemaName, specificName, this.excludeList)) {
                return false;
            }
            if (this.find(catalogName, schemaName, name, this.excludeList)) {
                return false;
            }
        }
        if (this.includeList.size() == 0) {
            return true;
        }
        if (this.find(catalogName, schemaName, specificName, this.includeList)) {
            return true;
        }
        return this.find(catalogName, schemaName, name, this.includeList);
    }

    private boolean find(String catalogName, String schemaName, String name, List<SchemaObjectNameHolder> list) {
        for (SchemaObjectNameHolder objectNameHolder : list) {
            if (!CommonUtils.eq(objectNameHolder.getObjectName(), name) || objectNameHolder.getSchemaName() != null && !CommonUtils.eq(objectNameHolder.getSchemaName(), schemaName)) continue;
            return objectNameHolder.getCatalogName() == null || CommonUtils.eq(objectNameHolder.getCatalogName(), catalogName);
        }
        return false;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this.getClass());
        this.toString(builder);
        return builder.toString();
    }

    protected void toString(ToStringBuilder builder) {
        builder.add("includeSchemas", (Object)this.includeSchemas);
        builder.add("excludeSchemas", (Object)this.excludeSchemas);
        builder.add("includes", (Object)this.includes);
        builder.add("excludes", (Object)this.excludes);
    }

    static class SchemaNameHolder {
        String catalogName;
        String schemaName;

        SchemaNameHolder(String name) {
            String[] splits = name.split("\\.");
            if (splits.length == 1) {
                this.catalogName = null;
            } else if (splits.length != 2) {
                throw new IllegalArgumentException("name=" + name);
            }
            this.schemaName = CommonUtils.last(splits);
        }
    }
}

